@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.ConfigurationSetDeliveryOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property tlsPolicy Whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is `Require`, messages are only delivered if a TLS connection can be established. If the value is `Optional`, messages can be delivered in plain text if a TLS connection can't be established. Valid values: `Require` or `Optional`. Defaults to `Optional`.
 */
public data class ConfigurationSetDeliveryOptionsArgs(
    public val tlsPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.ConfigurationSetDeliveryOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.ConfigurationSetDeliveryOptionsArgs =
        com.pulumi.aws.ses.inputs.ConfigurationSetDeliveryOptionsArgs.builder()
            .tlsPolicy(tlsPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetDeliveryOptionsArgs].
 */
@PulumiTagMarker
public class ConfigurationSetDeliveryOptionsArgsBuilder internal constructor() {
    private var tlsPolicy: Output<String>? = null

    /**
     * @param value Whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is `Require`, messages are only delivered if a TLS connection can be established. If the value is `Optional`, messages can be delivered in plain text if a TLS connection can't be established. Valid values: `Require` or `Optional`. Defaults to `Optional`.
     */
    @JvmName("vnyyhpaowwkosnpg")
    public suspend fun tlsPolicy(`value`: Output<String>) {
        this.tlsPolicy = value
    }

    /**
     * @param value Whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is `Require`, messages are only delivered if a TLS connection can be established. If the value is `Optional`, messages can be delivered in plain text if a TLS connection can't be established. Valid values: `Require` or `Optional`. Defaults to `Optional`.
     */
    @JvmName("wjeokkybumtvfoms")
    public suspend fun tlsPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsPolicy = mapped
    }

    internal fun build(): ConfigurationSetDeliveryOptionsArgs = ConfigurationSetDeliveryOptionsArgs(
        tlsPolicy = tlsPolicy,
    )
}
