@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.EventDestinationCloudwatchDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultValue The default value for the event
 * @property dimensionName The name for the dimension
 * @property valueSource The source for the value. May be any of `"messageTag"`, `"emailHeader"` or `"linkTag"`.
 */
public data class EventDestinationCloudwatchDestinationArgs(
    public val defaultValue: Output<String>,
    public val dimensionName: Output<String>,
    public val valueSource: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.EventDestinationCloudwatchDestinationArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.EventDestinationCloudwatchDestinationArgs =
        com.pulumi.aws.ses.inputs.EventDestinationCloudwatchDestinationArgs.builder()
            .defaultValue(defaultValue.applyValue({ args0 -> args0 }))
            .dimensionName(dimensionName.applyValue({ args0 -> args0 }))
            .valueSource(valueSource.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventDestinationCloudwatchDestinationArgs].
 */
@PulumiTagMarker
public class EventDestinationCloudwatchDestinationArgsBuilder internal constructor() {
    private var defaultValue: Output<String>? = null

    private var dimensionName: Output<String>? = null

    private var valueSource: Output<String>? = null

    /**
     * @param value The default value for the event
     */
    @JvmName("voxrpajcierwijwq")
    public suspend fun defaultValue(`value`: Output<String>) {
        this.defaultValue = value
    }

    /**
     * @param value The name for the dimension
     */
    @JvmName("nylqnhcavyyggmun")
    public suspend fun dimensionName(`value`: Output<String>) {
        this.dimensionName = value
    }

    /**
     * @param value The source for the value. May be any of `"messageTag"`, `"emailHeader"` or `"linkTag"`.
     */
    @JvmName("uxnbbvnecsvuycqk")
    public suspend fun valueSource(`value`: Output<String>) {
        this.valueSource = value
    }

    /**
     * @param value The default value for the event
     */
    @JvmName("mjeuraogobebemyx")
    public suspend fun defaultValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value The name for the dimension
     */
    @JvmName("kfamqypwjhtbfxmf")
    public suspend fun dimensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensionName = mapped
    }

    /**
     * @param value The source for the value. May be any of `"messageTag"`, `"emailHeader"` or `"linkTag"`.
     */
    @JvmName("qkfqkwesuwrmfkwv")
    public suspend fun valueSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueSource = mapped
    }

    internal fun build(): EventDestinationCloudwatchDestinationArgs =
        EventDestinationCloudwatchDestinationArgs(
            defaultValue = defaultValue ?: throw PulumiNullFieldException("defaultValue"),
            dimensionName = dimensionName ?: throw PulumiNullFieldException("dimensionName"),
            valueSource = valueSource ?: throw PulumiNullFieldException("valueSource"),
        )
}
