@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.EventDestinationKinesisDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property roleArn The ARN of the role that has permissions to access the Kinesis Stream
 * @property streamArn The ARN of the Kinesis Stream
 */
public data class EventDestinationKinesisDestinationArgs(
    public val roleArn: Output<String>,
    public val streamArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.EventDestinationKinesisDestinationArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.EventDestinationKinesisDestinationArgs =
        com.pulumi.aws.ses.inputs.EventDestinationKinesisDestinationArgs.builder()
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .streamArn(streamArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventDestinationKinesisDestinationArgs].
 */
@PulumiTagMarker
public class EventDestinationKinesisDestinationArgsBuilder internal constructor() {
    private var roleArn: Output<String>? = null

    private var streamArn: Output<String>? = null

    /**
     * @param value The ARN of the role that has permissions to access the Kinesis Stream
     */
    @JvmName("axiwydhgycewgrnl")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The ARN of the Kinesis Stream
     */
    @JvmName("xrdwtrbvfekchrdt")
    public suspend fun streamArn(`value`: Output<String>) {
        this.streamArn = value
    }

    /**
     * @param value The ARN of the role that has permissions to access the Kinesis Stream
     */
    @JvmName("cddwimivwxqrdrty")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The ARN of the Kinesis Stream
     */
    @JvmName("mhkalbehypbbqxwc")
    public suspend fun streamArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamArn = mapped
    }

    internal fun build(): EventDestinationKinesisDestinationArgs =
        EventDestinationKinesisDestinationArgs(
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            streamArn = streamArn ?: throw PulumiNullFieldException("streamArn"),
        )
}
