@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.ReceiptRuleLambdaActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property functionArn The ARN of the Lambda function to invoke
 * @property invocationType `Event` or `RequestResponse`
 * @property position The position of the action in the receipt rule
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleLambdaActionArgs(
    public val functionArn: Output<String>,
    public val invocationType: Output<String>? = null,
    public val position: Output<Int>,
    public val topicArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.ReceiptRuleLambdaActionArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.ReceiptRuleLambdaActionArgs =
        com.pulumi.aws.ses.inputs.ReceiptRuleLambdaActionArgs.builder()
            .functionArn(functionArn.applyValue({ args0 -> args0 }))
            .invocationType(invocationType?.applyValue({ args0 -> args0 }))
            .position(position.applyValue({ args0 -> args0 }))
            .topicArn(topicArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiptRuleLambdaActionArgs].
 */
@PulumiTagMarker
public class ReceiptRuleLambdaActionArgsBuilder internal constructor() {
    private var functionArn: Output<String>? = null

    private var invocationType: Output<String>? = null

    private var position: Output<Int>? = null

    private var topicArn: Output<String>? = null

    /**
     * @param value The ARN of the Lambda function to invoke
     */
    @JvmName("nhhktnpwpcrcqpbn")
    public suspend fun functionArn(`value`: Output<String>) {
        this.functionArn = value
    }

    /**
     * @param value `Event` or `RequestResponse`
     */
    @JvmName("qagqtncwwbdlrdal")
    public suspend fun invocationType(`value`: Output<String>) {
        this.invocationType = value
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("xdwjpqlinobgdhro")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("mcbrheektrdjgkjv")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value The ARN of the Lambda function to invoke
     */
    @JvmName("gmrrumllshetxfyr")
    public suspend fun functionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.functionArn = mapped
    }

    /**
     * @param value `Event` or `RequestResponse`
     */
    @JvmName("amgjvexknschdcxo")
    public suspend fun invocationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invocationType = mapped
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("gnxqqxuhsaecefwg")
    public suspend fun position(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("obhtuytaiyvxdfus")
    public suspend fun topicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): ReceiptRuleLambdaActionArgs = ReceiptRuleLambdaActionArgs(
        functionArn = functionArn ?: throw PulumiNullFieldException("functionArn"),
        invocationType = invocationType,
        position = position ?: throw PulumiNullFieldException("position"),
        topicArn = topicArn,
    )
}
