@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.ReceiptRuleS3ActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName The name of the S3 bucket
 * @property kmsKeyArn The ARN of the KMS key
 * @property objectKeyPrefix The key prefix of the S3 bucket
 * @property position The position of the action in the receipt rule
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleS3ActionArgs(
    public val bucketName: Output<String>,
    public val kmsKeyArn: Output<String>? = null,
    public val objectKeyPrefix: Output<String>? = null,
    public val position: Output<Int>,
    public val topicArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.ReceiptRuleS3ActionArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.ReceiptRuleS3ActionArgs =
        com.pulumi.aws.ses.inputs.ReceiptRuleS3ActionArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .objectKeyPrefix(objectKeyPrefix?.applyValue({ args0 -> args0 }))
            .position(position.applyValue({ args0 -> args0 }))
            .topicArn(topicArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiptRuleS3ActionArgs].
 */
@PulumiTagMarker
public class ReceiptRuleS3ActionArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    private var objectKeyPrefix: Output<String>? = null

    private var position: Output<Int>? = null

    private var topicArn: Output<String>? = null

    /**
     * @param value The name of the S3 bucket
     */
    @JvmName("cwtfxplgabjgjpmu")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The ARN of the KMS key
     */
    @JvmName("jcdkwojygciwhnri")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The key prefix of the S3 bucket
     */
    @JvmName("tbqiloyrjhhgscby")
    public suspend fun objectKeyPrefix(`value`: Output<String>) {
        this.objectKeyPrefix = value
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("prdeswetpisfwkxt")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("ifndybdvtgvmnmpq")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value The name of the S3 bucket
     */
    @JvmName("sjcnersxyplclasl")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The ARN of the KMS key
     */
    @JvmName("uxitlxlndjbuixsn")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value The key prefix of the S3 bucket
     */
    @JvmName("prifcuibaqlykkme")
    public suspend fun objectKeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectKeyPrefix = mapped
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("dbslcyfjctlkifhu")
    public suspend fun position(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("dsedsaaopbmqgcjp")
    public suspend fun topicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): ReceiptRuleS3ActionArgs = ReceiptRuleS3ActionArgs(
        bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        kmsKeyArn = kmsKeyArn,
        objectKeyPrefix = objectKeyPrefix,
        position = position ?: throw PulumiNullFieldException("position"),
        topicArn = topicArn,
    )
}
