@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.inputs

import com.pulumi.aws.ses.inputs.ReceiptRuleStopActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property position The position of the action in the receipt rule
 * @property scope The scope to apply. The only acceptable value is `RuleSet`.
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleStopActionArgs(
    public val position: Output<Int>,
    public val scope: Output<String>,
    public val topicArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.inputs.ReceiptRuleStopActionArgs> {
    override fun toJava(): com.pulumi.aws.ses.inputs.ReceiptRuleStopActionArgs =
        com.pulumi.aws.ses.inputs.ReceiptRuleStopActionArgs.builder()
            .position(position.applyValue({ args0 -> args0 }))
            .scope(scope.applyValue({ args0 -> args0 }))
            .topicArn(topicArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReceiptRuleStopActionArgs].
 */
@PulumiTagMarker
public class ReceiptRuleStopActionArgsBuilder internal constructor() {
    private var position: Output<Int>? = null

    private var scope: Output<String>? = null

    private var topicArn: Output<String>? = null

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("ycljcchtrgiqktnc")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value The scope to apply. The only acceptable value is `RuleSet`.
     */
    @JvmName("jhawbmtxxrjcgjff")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("undmbndmgufbpxpf")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value The position of the action in the receipt rule
     */
    @JvmName("hycwvcslddgngpdd")
    public suspend fun position(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param value The scope to apply. The only acceptable value is `RuleSet`.
     */
    @JvmName("yoapxrhartvccxbj")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The ARN of an SNS topic to notify
     */
    @JvmName("fcqkabansyvtmarj")
    public suspend fun topicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): ReceiptRuleStopActionArgs = ReceiptRuleStopActionArgs(
        position = position ?: throw PulumiNullFieldException("position"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
        topicArn = topicArn,
    )
}
