@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultValue The default value for the event
 * @property dimensionName The name for the dimension
 * @property valueSource The source for the value. May be any of `"messageTag"`, `"emailHeader"` or `"linkTag"`.
 */
public data class EventDestinationCloudwatchDestination(
    public val defaultValue: String,
    public val dimensionName: String,
    public val valueSource: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.EventDestinationCloudwatchDestination): EventDestinationCloudwatchDestination = EventDestinationCloudwatchDestination(
            defaultValue = javaType.defaultValue(),
            dimensionName = javaType.dimensionName(),
            valueSource = javaType.valueSource(),
        )
    }
}
