@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property headerName The name of the header to add
 * @property headerValue The value of the header to add
 * @property position The position of the action in the receipt rule
 */
public data class ReceiptRuleAddHeaderAction(
    public val headerName: String,
    public val headerValue: String,
    public val position: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.ReceiptRuleAddHeaderAction): ReceiptRuleAddHeaderAction = ReceiptRuleAddHeaderAction(
            headerName = javaType.headerName(),
            headerValue = javaType.headerValue(),
            position = javaType.position(),
        )
    }
}
