@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property functionArn The ARN of the Lambda function to invoke
 * @property invocationType `Event` or `RequestResponse`
 * @property position The position of the action in the receipt rule
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleLambdaAction(
    public val functionArn: String,
    public val invocationType: String? = null,
    public val position: Int,
    public val topicArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.ReceiptRuleLambdaAction): ReceiptRuleLambdaAction = ReceiptRuleLambdaAction(
            functionArn = javaType.functionArn(),
            invocationType = javaType.invocationType().map({ args0 -> args0 }).orElse(null),
            position = javaType.position(),
            topicArn = javaType.topicArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
