@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The name of the S3 bucket
 * @property kmsKeyArn The ARN of the KMS key
 * @property objectKeyPrefix The key prefix of the S3 bucket
 * @property position The position of the action in the receipt rule
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleS3Action(
    public val bucketName: String,
    public val kmsKeyArn: String? = null,
    public val objectKeyPrefix: String? = null,
    public val position: Int,
    public val topicArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.ReceiptRuleS3Action): ReceiptRuleS3Action = ReceiptRuleS3Action(
            bucketName = javaType.bucketName(),
            kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
            objectKeyPrefix = javaType.objectKeyPrefix().map({ args0 -> args0 }).orElse(null),
            position = javaType.position(),
            topicArn = javaType.topicArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
