@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property organizationArn The ARN of the WorkMail organization
 * @property position The position of the action in the receipt rule
 * @property topicArn The ARN of an SNS topic to notify
 */
public data class ReceiptRuleWorkmailAction(
    public val organizationArn: String,
    public val position: Int,
    public val topicArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ses.outputs.ReceiptRuleWorkmailAction): ReceiptRuleWorkmailAction = ReceiptRuleWorkmailAction(
            organizationArn = javaType.organizationArn(),
            position = javaType.position(),
            topicArn = javaType.topicArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
