@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.kotlin.outputs.AccountVdmAttributesDashboardAttributes
import com.pulumi.aws.sesv2.kotlin.outputs.AccountVdmAttributesGuardianAttributes
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.sesv2.kotlin.outputs.AccountVdmAttributesDashboardAttributes.Companion.toKotlin as accountVdmAttributesDashboardAttributesToKotlin
import com.pulumi.aws.sesv2.kotlin.outputs.AccountVdmAttributesGuardianAttributes.Companion.toKotlin as accountVdmAttributesGuardianAttributesToKotlin

/**
 * Builder for [AccountVdmAttributes].
 */
@PulumiTagMarker
public class AccountVdmAttributesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountVdmAttributesArgs = AccountVdmAttributesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountVdmAttributesArgsBuilder.() -> Unit) {
        val builder = AccountVdmAttributesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccountVdmAttributes {
        val builtJavaResource = com.pulumi.aws.sesv2.AccountVdmAttributes(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountVdmAttributes(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Account VDM Attributes.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.AccountVdmAttributes("example", {
 *     vdmEnabled: "ENABLED",
 *     dashboardAttributes: {
 *         engagementMetrics: "ENABLED",
 *     },
 *     guardianAttributes: {
 *         optimizedSharedDelivery: "ENABLED",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.AccountVdmAttributes("example",
 *     vdm_enabled="ENABLED",
 *     dashboard_attributes={
 *         "engagement_metrics": "ENABLED",
 *     },
 *     guardian_attributes={
 *         "optimized_shared_delivery": "ENABLED",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.AccountVdmAttributes("example", new()
 *     {
 *         VdmEnabled = "ENABLED",
 *         DashboardAttributes = new Aws.SesV2.Inputs.AccountVdmAttributesDashboardAttributesArgs
 *         {
 *             EngagementMetrics = "ENABLED",
 *         },
 *         GuardianAttributes = new Aws.SesV2.Inputs.AccountVdmAttributesGuardianAttributesArgs
 *         {
 *             OptimizedSharedDelivery = "ENABLED",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sesv2.NewAccountVdmAttributes(ctx, "example", &sesv2.AccountVdmAttributesArgs{
 * 			VdmEnabled: pulumi.String("ENABLED"),
 * 			DashboardAttributes: &sesv2.AccountVdmAttributesDashboardAttributesArgs{
 * 				EngagementMetrics: pulumi.String("ENABLED"),
 * 			},
 * 			GuardianAttributes: &sesv2.AccountVdmAttributesGuardianAttributesArgs{
 * 				OptimizedSharedDelivery: pulumi.String("ENABLED"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.AccountVdmAttributes;
 * import com.pulumi.aws.sesv2.AccountVdmAttributesArgs;
 * import com.pulumi.aws.sesv2.inputs.AccountVdmAttributesDashboardAttributesArgs;
 * import com.pulumi.aws.sesv2.inputs.AccountVdmAttributesGuardianAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccountVdmAttributes("example", AccountVdmAttributesArgs.builder()
 *             .vdmEnabled("ENABLED")
 *             .dashboardAttributes(AccountVdmAttributesDashboardAttributesArgs.builder()
 *                 .engagementMetrics("ENABLED")
 *                 .build())
 *             .guardianAttributes(AccountVdmAttributesGuardianAttributesArgs.builder()
 *                 .optimizedSharedDelivery("ENABLED")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:AccountVdmAttributes
 *     properties:
 *       vdmEnabled: ENABLED
 *       dashboardAttributes:
 *         engagementMetrics: ENABLED
 *       guardianAttributes:
 *         optimizedSharedDelivery: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Account VDM Attributes using the word `ses-account-vdm-attributes`. For example:
 * ```sh
 * $ pulumi import aws:sesv2/accountVdmAttributes:AccountVdmAttributes example ses-account-vdm-attributes
 * ```
 */
public class AccountVdmAttributes internal constructor(
    override val javaResource: com.pulumi.aws.sesv2.AccountVdmAttributes,
) : KotlinCustomResource(javaResource, AccountVdmAttributesMapper) {
    /**
     * Specifies additional settings for your VDM configuration as applicable to the Dashboard.
     */
    public val dashboardAttributes: Output<AccountVdmAttributesDashboardAttributes>
        get() = javaResource.dashboardAttributes().applyValue({ args0 ->
            args0.let({ args0 ->
                accountVdmAttributesDashboardAttributesToKotlin(args0)
            })
        })

    /**
     * Specifies additional settings for your VDM configuration as applicable to the Guardian.
     */
    public val guardianAttributes: Output<AccountVdmAttributesGuardianAttributes>
        get() = javaResource.guardianAttributes().applyValue({ args0 ->
            args0.let({ args0 ->
                accountVdmAttributesGuardianAttributesToKotlin(args0)
            })
        })

    /**
     * Specifies the status of your VDM configuration. Valid values: `ENABLED`, `DISABLED`.
     * The following arguments are optional:
     */
    public val vdmEnabled: Output<String>
        get() = javaResource.vdmEnabled().applyValue({ args0 -> args0 })
}

public object AccountVdmAttributesMapper : ResourceMapper<AccountVdmAttributes> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sesv2.AccountVdmAttributes::class == javaResource::class

    override fun map(javaResource: Resource): AccountVdmAttributes = AccountVdmAttributes(
        javaResource
            as com.pulumi.aws.sesv2.AccountVdmAttributes,
    )
}

/**
 * @see [AccountVdmAttributes].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountVdmAttributes].
 */
public suspend fun accountVdmAttributes(
    name: String,
    block: suspend AccountVdmAttributesResourceBuilder.() -> Unit,
): AccountVdmAttributes {
    val builder = AccountVdmAttributesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountVdmAttributes].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountVdmAttributes(name: String): AccountVdmAttributes {
    val builder = AccountVdmAttributesResourceBuilder()
    builder.name(name)
    return builder.build()
}
