@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetDeliveryOptions
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetReputationOptions
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetSendingOptions
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetSuppressionOptions
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetTrackingOptions
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetVdmOptions
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetDeliveryOptions.Companion.toKotlin as configurationSetDeliveryOptionsToKotlin
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetReputationOptions.Companion.toKotlin as configurationSetReputationOptionsToKotlin
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetSendingOptions.Companion.toKotlin as configurationSetSendingOptionsToKotlin
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetSuppressionOptions.Companion.toKotlin as configurationSetSuppressionOptionsToKotlin
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetTrackingOptions.Companion.toKotlin as configurationSetTrackingOptionsToKotlin
import com.pulumi.aws.sesv2.kotlin.outputs.ConfigurationSetVdmOptions.Companion.toKotlin as configurationSetVdmOptionsToKotlin

/**
 * Builder for [ConfigurationSet].
 */
@PulumiTagMarker
public class ConfigurationSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationSetArgs = ConfigurationSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationSetArgsBuilder.() -> Unit) {
        val builder = ConfigurationSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConfigurationSet {
        val builtJavaResource = com.pulumi.aws.sesv2.ConfigurationSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConfigurationSet(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Configuration Set.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.ConfigurationSet("example", {
 *     configurationSetName: "example",
 *     deliveryOptions: {
 *         tlsPolicy: "REQUIRE",
 *     },
 *     reputationOptions: {
 *         reputationMetricsEnabled: false,
 *     },
 *     sendingOptions: {
 *         sendingEnabled: true,
 *     },
 *     suppressionOptions: {
 *         suppressedReasons: [
 *             "BOUNCE",
 *             "COMPLAINT",
 *         ],
 *     },
 *     trackingOptions: {
 *         customRedirectDomain: "example.com",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.ConfigurationSet("example",
 *     configuration_set_name="example",
 *     delivery_options={
 *         "tls_policy": "REQUIRE",
 *     },
 *     reputation_options={
 *         "reputation_metrics_enabled": False,
 *     },
 *     sending_options={
 *         "sending_enabled": True,
 *     },
 *     suppression_options={
 *         "suppressed_reasons": [
 *             "BOUNCE",
 *             "COMPLAINT",
 *         ],
 *     },
 *     tracking_options={
 *         "custom_redirect_domain": "example.com",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.ConfigurationSet("example", new()
 *     {
 *         ConfigurationSetName = "example",
 *         DeliveryOptions = new Aws.SesV2.Inputs.ConfigurationSetDeliveryOptionsArgs
 *         {
 *             TlsPolicy = "REQUIRE",
 *         },
 *         ReputationOptions = new Aws.SesV2.Inputs.ConfigurationSetReputationOptionsArgs
 *         {
 *             ReputationMetricsEnabled = false,
 *         },
 *         SendingOptions = new Aws.SesV2.Inputs.ConfigurationSetSendingOptionsArgs
 *         {
 *             SendingEnabled = true,
 *         },
 *         SuppressionOptions = new Aws.SesV2.Inputs.ConfigurationSetSuppressionOptionsArgs
 *         {
 *             SuppressedReasons = new[]
 *             {
 *                 "BOUNCE",
 *                 "COMPLAINT",
 *             },
 *         },
 *         TrackingOptions = new Aws.SesV2.Inputs.ConfigurationSetTrackingOptionsArgs
 *         {
 *             CustomRedirectDomain = "example.com",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sesv2.NewConfigurationSet(ctx, "example", &sesv2.ConfigurationSetArgs{
 * 			ConfigurationSetName: pulumi.String("example"),
 * 			DeliveryOptions: &sesv2.ConfigurationSetDeliveryOptionsArgs{
 * 				TlsPolicy: pulumi.String("REQUIRE"),
 * 			},
 * 			ReputationOptions: &sesv2.ConfigurationSetReputationOptionsArgs{
 * 				ReputationMetricsEnabled: pulumi.Bool(false),
 * 			},
 * 			SendingOptions: &sesv2.ConfigurationSetSendingOptionsArgs{
 * 				SendingEnabled: pulumi.Bool(true),
 * 			},
 * 			SuppressionOptions: &sesv2.ConfigurationSetSuppressionOptionsArgs{
 * 				SuppressedReasons: pulumi.StringArray{
 * 					pulumi.String("BOUNCE"),
 * 					pulumi.String("COMPLAINT"),
 * 				},
 * 			},
 * 			TrackingOptions: &sesv2.ConfigurationSetTrackingOptionsArgs{
 * 				CustomRedirectDomain: pulumi.String("example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ConfigurationSet;
 * import com.pulumi.aws.sesv2.ConfigurationSetArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetDeliveryOptionsArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetReputationOptionsArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetSendingOptionsArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetSuppressionOptionsArgs;
 * import com.pulumi.aws.sesv2.inputs.ConfigurationSetTrackingOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConfigurationSet("example", ConfigurationSetArgs.builder()
 *             .configurationSetName("example")
 *             .deliveryOptions(ConfigurationSetDeliveryOptionsArgs.builder()
 *                 .tlsPolicy("REQUIRE")
 *                 .build())
 *             .reputationOptions(ConfigurationSetReputationOptionsArgs.builder()
 *                 .reputationMetricsEnabled(false)
 *                 .build())
 *             .sendingOptions(ConfigurationSetSendingOptionsArgs.builder()
 *                 .sendingEnabled(true)
 *                 .build())
 *             .suppressionOptions(ConfigurationSetSuppressionOptionsArgs.builder()
 *                 .suppressedReasons(
 *                     "BOUNCE",
 *                     "COMPLAINT")
 *                 .build())
 *             .trackingOptions(ConfigurationSetTrackingOptionsArgs.builder()
 *                 .customRedirectDomain("example.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:ConfigurationSet
 *     properties:
 *       configurationSetName: example
 *       deliveryOptions:
 *         tlsPolicy: REQUIRE
 *       reputationOptions:
 *         reputationMetricsEnabled: false
 *       sendingOptions:
 *         sendingEnabled: true
 *       suppressionOptions:
 *         suppressedReasons:
 *           - BOUNCE
 *           - COMPLAINT
 *       trackingOptions:
 *         customRedirectDomain: example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Configuration Set using the `configuration_set_name`. For example:
 * ```sh
 * $ pulumi import aws:sesv2/configurationSet:ConfigurationSet example example
 * ```
 */
public class ConfigurationSet internal constructor(
    override val javaResource: com.pulumi.aws.sesv2.ConfigurationSet,
) : KotlinCustomResource(javaResource, ConfigurationSetMapper) {
    /**
     * ARN of the Configuration Set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the configuration set.
     */
    public val configurationSetName: Output<String>
        get() = javaResource.configurationSetName().applyValue({ args0 -> args0 })

    /**
     * An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set. See `delivery_options` Block for details.
     */
    public val deliveryOptions: Output<ConfigurationSetDeliveryOptions>?
        get() = javaResource.deliveryOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> configurationSetDeliveryOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set. See `reputation_options` Block for details.
     */
    public val reputationOptions: Output<ConfigurationSetReputationOptions>
        get() = javaResource.reputationOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                configurationSetReputationOptionsToKotlin(args0)
            })
        })

    /**
     * An object that defines whether or not Amazon SES can send email that you send using the configuration set. See `sending_options` Block for details.
     */
    public val sendingOptions: Output<ConfigurationSetSendingOptions>
        get() = javaResource.sendingOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                configurationSetSendingOptionsToKotlin(args0)
            })
        })

    /**
     * An object that contains information about the suppression list preferences for your account. See `suppression_options` Block for details.
     */
    public val suppressionOptions: Output<ConfigurationSetSuppressionOptions>?
        get() = javaResource.suppressionOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> configurationSetSuppressionOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * An object that defines the open and click tracking options for emails that you send using the configuration set. See `tracking_options` Block for details.
     */
    public val trackingOptions: Output<ConfigurationSetTrackingOptions>?
        get() = javaResource.trackingOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> configurationSetTrackingOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * An object that defines the VDM settings that apply to emails that you send using the configuration set. See `vdm_options` Block for details.
     */
    public val vdmOptions: Output<ConfigurationSetVdmOptions>?
        get() = javaResource.vdmOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    configurationSetVdmOptionsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ConfigurationSetMapper : ResourceMapper<ConfigurationSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sesv2.ConfigurationSet::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationSet = ConfigurationSet(
        javaResource as
            com.pulumi.aws.sesv2.ConfigurationSet,
    )
}

/**
 * @see [ConfigurationSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationSet].
 */
public suspend fun configurationSet(
    name: String,
    block: suspend ConfigurationSetResourceBuilder.() -> Unit,
): ConfigurationSet {
    val builder = ConfigurationSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationSet(name: String): ConfigurationSet {
    val builder = ConfigurationSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
