@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.ContactListArgs.builder
import com.pulumi.aws.sesv2.kotlin.inputs.ContactListTopicArgs
import com.pulumi.aws.sesv2.kotlin.inputs.ContactListTopicArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Contact List.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.ContactList("example", {contactListName: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.ContactList("example", contact_list_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.ContactList("example", new()
 *     {
 *         ContactListName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sesv2.NewContactList(ctx, "example", &sesv2.ContactListArgs{
 * 			ContactListName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ContactList;
 * import com.pulumi.aws.sesv2.ContactListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactList("example", ContactListArgs.builder()
 *             .contactListName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:ContactList
 *     properties:
 *       contactListName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Extended Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.ContactList("example", {
 *     contactListName: "example",
 *     description: "description",
 *     topics: [{
 *         defaultSubscriptionStatus: "OPT_IN",
 *         description: "topic description",
 *         displayName: "Example Topic",
 *         topicName: "example-topic",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.ContactList("example",
 *     contact_list_name="example",
 *     description="description",
 *     topics=[{
 *         "default_subscription_status": "OPT_IN",
 *         "description": "topic description",
 *         "display_name": "Example Topic",
 *         "topic_name": "example-topic",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.ContactList("example", new()
 *     {
 *         ContactListName = "example",
 *         Description = "description",
 *         Topics = new[]
 *         {
 *             new Aws.SesV2.Inputs.ContactListTopicArgs
 *             {
 *                 DefaultSubscriptionStatus = "OPT_IN",
 *                 Description = "topic description",
 *                 DisplayName = "Example Topic",
 *                 TopicName = "example-topic",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sesv2.NewContactList(ctx, "example", &sesv2.ContactListArgs{
 * 			ContactListName: pulumi.String("example"),
 * 			Description:     pulumi.String("description"),
 * 			Topics: sesv2.ContactListTopicArray{
 * 				&sesv2.ContactListTopicArgs{
 * 					DefaultSubscriptionStatus: pulumi.String("OPT_IN"),
 * 					Description:               pulumi.String("topic description"),
 * 					DisplayName:               pulumi.String("Example Topic"),
 * 					TopicName:                 pulumi.String("example-topic"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.ContactList;
 * import com.pulumi.aws.sesv2.ContactListArgs;
 * import com.pulumi.aws.sesv2.inputs.ContactListTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactList("example", ContactListArgs.builder()
 *             .contactListName("example")
 *             .description("description")
 *             .topics(ContactListTopicArgs.builder()
 *                 .defaultSubscriptionStatus("OPT_IN")
 *                 .description("topic description")
 *                 .displayName("Example Topic")
 *                 .topicName("example-topic")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:ContactList
 *     properties:
 *       contactListName: example
 *       description: description
 *       topics:
 *         - defaultSubscriptionStatus: OPT_IN
 *           description: topic description
 *           displayName: Example Topic
 *           topicName: example-topic
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Contact List using the `id`. For example:
 * ```sh
 * $ pulumi import aws:sesv2/contactList:ContactList example example
 * ```
 * @property contactListName Name of the contact list.
 * The following arguments are optional:
 * @property description Description of what the contact list is about.
 * @property tags Key-value map of resource tags for the contact list. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property topics Configuration block(s) with topic for the contact list. Detailed below.
 */
public data class ContactListArgs(
    public val contactListName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topics: Output<List<ContactListTopicArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.ContactListArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.ContactListArgs =
        com.pulumi.aws.sesv2.ContactListArgs.builder()
            .contactListName(contactListName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topics(
                topics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContactListArgs].
 */
@PulumiTagMarker
public class ContactListArgsBuilder internal constructor() {
    private var contactListName: Output<String>? = null

    private var description: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topics: Output<List<ContactListTopicArgs>>? = null

    /**
     * @param value Name of the contact list.
     * The following arguments are optional:
     */
    @JvmName("hdpdgyosddmglldv")
    public suspend fun contactListName(`value`: Output<String>) {
        this.contactListName = value
    }

    /**
     * @param value Description of what the contact list is about.
     */
    @JvmName("ljoaphxqsqepkpfj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Key-value map of resource tags for the contact list. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("phkyifbeiioyselu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("hbikpgmfcdlbsduj")
    public suspend fun topics(`value`: Output<List<ContactListTopicArgs>>) {
        this.topics = value
    }

    @JvmName("rgaicovrqaxuophg")
    public suspend fun topics(vararg values: Output<ContactListTopicArgs>) {
        this.topics = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("ikwnueabxgbokooc")
    public suspend fun topics(values: List<Output<ContactListTopicArgs>>) {
        this.topics = Output.all(values)
    }

    /**
     * @param value Name of the contact list.
     * The following arguments are optional:
     */
    @JvmName("wsevkjjheahyjorv")
    public suspend fun contactListName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactListName = mapped
    }

    /**
     * @param value Description of what the contact list is about.
     */
    @JvmName("epecvklmwbvpifyg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Key-value map of resource tags for the contact list. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xeghjbbfcknqvvsj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the contact list. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nvfhjbjchiphiutf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("ehvhcebwccdxgtbo")
    public suspend fun topics(`value`: List<ContactListTopicArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topics = mapped
    }

    /**
     * @param argument Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("gpnnagujabwvdndt")
    public suspend fun topics(argument: List<suspend ContactListTopicArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactListTopicArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.topics = mapped
    }

    /**
     * @param argument Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("wnbdsnconjcjmqrp")
    public suspend fun topics(vararg argument: suspend ContactListTopicArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContactListTopicArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.topics = mapped
    }

    /**
     * @param argument Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("jednujsgkhdbdusa")
    public suspend fun topics(argument: suspend ContactListTopicArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContactListTopicArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.topics = mapped
    }

    /**
     * @param values Configuration block(s) with topic for the contact list. Detailed below.
     */
    @JvmName("covwnprcrhxffvhs")
    public suspend fun topics(vararg values: ContactListTopicArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topics = mapped
    }

    internal fun build(): ContactListArgs = ContactListArgs(
        contactListName = contactListName,
        description = description,
        tags = tags,
        topics = topics,
    )
}
