@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DedicatedIpAssignment].
 */
@PulumiTagMarker
public class DedicatedIpAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedIpAssignmentArgs = DedicatedIpAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedIpAssignmentArgsBuilder.() -> Unit) {
        val builder = DedicatedIpAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DedicatedIpAssignment {
        val builtJavaResource = com.pulumi.aws.sesv2.DedicatedIpAssignment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DedicatedIpAssignment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Dedicated IP Assignment.
 * This resource is used with "Standard" dedicated IP addresses. This includes addresses [requested and relinquished manually](https://docs&#46;aws&#46;amazon&#46;com/ses/latest/dg/dedicated-ip-case&#46;html) via an AWS support case, or [Bring Your Own IP](https://docs&#46;aws&#46;amazon&#46;com/ses/latest/dg/dedicated-ip-byo&#46;html) addresses&#46; Once no longer assigned, this resource returns the IP to the [`ses-default-dedicated-pool`](https://docs.aws.amazon.com/ses/latest/dg/managing-ip-pools.html), managed by AWS.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.DedicatedIpAssignment("example", {
 *     ip: "0.0.0.0",
 *     destinationPoolName: "my-pool",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.DedicatedIpAssignment("example",
 *     ip="0.0.0.0",
 *     destination_pool_name="my-pool")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.DedicatedIpAssignment("example", new()
 *     {
 *         Ip = "0.0.0.0",
 *         DestinationPoolName = "my-pool",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sesv2.NewDedicatedIpAssignment(ctx, "example", &sesv2.DedicatedIpAssignmentArgs{
 * 			Ip:                  pulumi.String("0.0.0.0"),
 * 			DestinationPoolName: pulumi.String("my-pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.DedicatedIpAssignment;
 * import com.pulumi.aws.sesv2.DedicatedIpAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DedicatedIpAssignment("example", DedicatedIpAssignmentArgs.builder()
 *             .ip("0.0.0.0")
 *             .destinationPoolName("my-pool")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:DedicatedIpAssignment
 *     properties:
 *       ip: 0.0.0.0
 *       destinationPoolName: my-pool
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Dedicated IP Assignment using the `id`, which is a comma-separated string made up of `ip` and `destination_pool_name`. For example:
 * ```sh
 * $ pulumi import aws:sesv2/dedicatedIpAssignment:DedicatedIpAssignment example "0.0.0.0,my-pool"
 * ```
 */
public class DedicatedIpAssignment internal constructor(
    override val javaResource: com.pulumi.aws.sesv2.DedicatedIpAssignment,
) : KotlinCustomResource(javaResource, DedicatedIpAssignmentMapper) {
    /**
     * Dedicated IP address.
     */
    public val destinationPoolName: Output<String>
        get() = javaResource.destinationPoolName().applyValue({ args0 -> args0 })

    /**
     * Dedicated IP address.
     */
    public val ip: Output<String>
        get() = javaResource.ip().applyValue({ args0 -> args0 })
}

public object DedicatedIpAssignmentMapper : ResourceMapper<DedicatedIpAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sesv2.DedicatedIpAssignment::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedIpAssignment =
        DedicatedIpAssignment(javaResource as com.pulumi.aws.sesv2.DedicatedIpAssignment)
}

/**
 * @see [DedicatedIpAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedIpAssignment].
 */
public suspend fun dedicatedIpAssignment(
    name: String,
    block: suspend DedicatedIpAssignmentResourceBuilder.() -> Unit,
): DedicatedIpAssignment {
    val builder = DedicatedIpAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedIpAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedIpAssignment(name: String): DedicatedIpAssignment {
    val builder = DedicatedIpAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
