@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.DedicatedIpAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Dedicated IP Assignment.
 * This resource is used with "Standard" dedicated IP addresses. This includes addresses [requested and relinquished manually](https://docs&#46;aws&#46;amazon&#46;com/ses/latest/dg/dedicated-ip-case&#46;html) via an AWS support case, or [Bring Your Own IP](https://docs&#46;aws&#46;amazon&#46;com/ses/latest/dg/dedicated-ip-byo&#46;html) addresses&#46; Once no longer assigned, this resource returns the IP to the [`ses-default-dedicated-pool`](https://docs.aws.amazon.com/ses/latest/dg/managing-ip-pools.html), managed by AWS.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.DedicatedIpAssignment("example", {
 *     ip: "0.0.0.0",
 *     destinationPoolName: "my-pool",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.DedicatedIpAssignment("example",
 *     ip="0.0.0.0",
 *     destination_pool_name="my-pool")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.DedicatedIpAssignment("example", new()
 *     {
 *         Ip = "0.0.0.0",
 *         DestinationPoolName = "my-pool",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sesv2.NewDedicatedIpAssignment(ctx, "example", &sesv2.DedicatedIpAssignmentArgs{
 * 			Ip:                  pulumi.String("0.0.0.0"),
 * 			DestinationPoolName: pulumi.String("my-pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.DedicatedIpAssignment;
 * import com.pulumi.aws.sesv2.DedicatedIpAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DedicatedIpAssignment("example", DedicatedIpAssignmentArgs.builder()
 *             .ip("0.0.0.0")
 *             .destinationPoolName("my-pool")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:DedicatedIpAssignment
 *     properties:
 *       ip: 0.0.0.0
 *       destinationPoolName: my-pool
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Dedicated IP Assignment using the `id`, which is a comma-separated string made up of `ip` and `destination_pool_name`. For example:
 * ```sh
 * $ pulumi import aws:sesv2/dedicatedIpAssignment:DedicatedIpAssignment example "0.0.0.0,my-pool"
 * ```
 * @property destinationPoolName Dedicated IP address.
 * @property ip Dedicated IP address.
 */
public data class DedicatedIpAssignmentArgs(
    public val destinationPoolName: Output<String>? = null,
    public val ip: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.DedicatedIpAssignmentArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.DedicatedIpAssignmentArgs =
        com.pulumi.aws.sesv2.DedicatedIpAssignmentArgs.builder()
            .destinationPoolName(destinationPoolName?.applyValue({ args0 -> args0 }))
            .ip(ip?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DedicatedIpAssignmentArgs].
 */
@PulumiTagMarker
public class DedicatedIpAssignmentArgsBuilder internal constructor() {
    private var destinationPoolName: Output<String>? = null

    private var ip: Output<String>? = null

    /**
     * @param value Dedicated IP address.
     */
    @JvmName("jnufhciubvlkmgaj")
    public suspend fun destinationPoolName(`value`: Output<String>) {
        this.destinationPoolName = value
    }

    /**
     * @param value Dedicated IP address.
     */
    @JvmName("byftmnixxltyotqq")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value Dedicated IP address.
     */
    @JvmName("dpjilxnwqwccjeyu")
    public suspend fun destinationPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPoolName = mapped
    }

    /**
     * @param value Dedicated IP address.
     */
    @JvmName("pfnkolcqkkekdwjt")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    internal fun build(): DedicatedIpAssignmentArgs = DedicatedIpAssignmentArgs(
        destinationPoolName = destinationPoolName,
        ip = ip,
    )
}
