@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DedicatedIpPool].
 */
@PulumiTagMarker
public class DedicatedIpPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedIpPoolArgs = DedicatedIpPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedIpPoolArgsBuilder.() -> Unit) {
        val builder = DedicatedIpPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DedicatedIpPool {
        val builtJavaResource = com.pulumi.aws.sesv2.DedicatedIpPool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DedicatedIpPool(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Dedicated IP Pool.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.DedicatedIpPool("example", {poolName: "my-pool"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.DedicatedIpPool("example", pool_name="my-pool")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.DedicatedIpPool("example", new()
 *     {
 *         PoolName = "my-pool",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sesv2.NewDedicatedIpPool(ctx, "example", &sesv2.DedicatedIpPoolArgs{
 * 			PoolName: pulumi.String("my-pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.DedicatedIpPool;
 * import com.pulumi.aws.sesv2.DedicatedIpPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DedicatedIpPool("example", DedicatedIpPoolArgs.builder()
 *             .poolName("my-pool")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:DedicatedIpPool
 *     properties:
 *       poolName: my-pool
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Managed Pool
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.DedicatedIpPool("example", {
 *     poolName: "my-managed-pool",
 *     scalingMode: "MANAGED",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.DedicatedIpPool("example",
 *     pool_name="my-managed-pool",
 *     scaling_mode="MANAGED")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.DedicatedIpPool("example", new()
 *     {
 *         PoolName = "my-managed-pool",
 *         ScalingMode = "MANAGED",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sesv2.NewDedicatedIpPool(ctx, "example", &sesv2.DedicatedIpPoolArgs{
 * 			PoolName:    pulumi.String("my-managed-pool"),
 * 			ScalingMode: pulumi.String("MANAGED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.DedicatedIpPool;
 * import com.pulumi.aws.sesv2.DedicatedIpPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DedicatedIpPool("example", DedicatedIpPoolArgs.builder()
 *             .poolName("my-managed-pool")
 *             .scalingMode("MANAGED")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:DedicatedIpPool
 *     properties:
 *       poolName: my-managed-pool
 *       scalingMode: MANAGED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Dedicated IP Pool using the `pool_name`. For example:
 * ```sh
 * $ pulumi import aws:sesv2/dedicatedIpPool:DedicatedIpPool example my-pool
 * ```
 */
public class DedicatedIpPool internal constructor(
    override val javaResource: com.pulumi.aws.sesv2.DedicatedIpPool,
) : KotlinCustomResource(javaResource, DedicatedIpPoolMapper) {
    /**
     * ARN of the Dedicated IP Pool.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the dedicated IP pool.
     * The following arguments are optional:
     */
    public val poolName: Output<String>
        get() = javaResource.poolName().applyValue({ args0 -> args0 })

    /**
     * IP pool scaling mode. Valid values: `STANDARD`, `MANAGED`. If omitted, the AWS API will default to a standard pool.
     */
    public val scalingMode: Output<String>
        get() = javaResource.scalingMode().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DedicatedIpPoolMapper : ResourceMapper<DedicatedIpPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sesv2.DedicatedIpPool::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedIpPool = DedicatedIpPool(
        javaResource as
            com.pulumi.aws.sesv2.DedicatedIpPool,
    )
}

/**
 * @see [DedicatedIpPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedIpPool].
 */
public suspend fun dedicatedIpPool(
    name: String,
    block: suspend DedicatedIpPoolResourceBuilder.() -> Unit,
): DedicatedIpPool {
    val builder = DedicatedIpPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedIpPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedIpPool(name: String): DedicatedIpPool {
    val builder = DedicatedIpPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
