@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.DedicatedIpPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Dedicated IP Pool.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.DedicatedIpPool("example", {poolName: "my-pool"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.DedicatedIpPool("example", pool_name="my-pool")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.DedicatedIpPool("example", new()
 *     {
 *         PoolName = "my-pool",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sesv2.NewDedicatedIpPool(ctx, "example", &sesv2.DedicatedIpPoolArgs{
 * 			PoolName: pulumi.String("my-pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.DedicatedIpPool;
 * import com.pulumi.aws.sesv2.DedicatedIpPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DedicatedIpPool("example", DedicatedIpPoolArgs.builder()
 *             .poolName("my-pool")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:DedicatedIpPool
 *     properties:
 *       poolName: my-pool
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Managed Pool
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.DedicatedIpPool("example", {
 *     poolName: "my-managed-pool",
 *     scalingMode: "MANAGED",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.DedicatedIpPool("example",
 *     pool_name="my-managed-pool",
 *     scaling_mode="MANAGED")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.DedicatedIpPool("example", new()
 *     {
 *         PoolName = "my-managed-pool",
 *         ScalingMode = "MANAGED",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sesv2.NewDedicatedIpPool(ctx, "example", &sesv2.DedicatedIpPoolArgs{
 * 			PoolName:    pulumi.String("my-managed-pool"),
 * 			ScalingMode: pulumi.String("MANAGED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.DedicatedIpPool;
 * import com.pulumi.aws.sesv2.DedicatedIpPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DedicatedIpPool("example", DedicatedIpPoolArgs.builder()
 *             .poolName("my-managed-pool")
 *             .scalingMode("MANAGED")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:DedicatedIpPool
 *     properties:
 *       poolName: my-managed-pool
 *       scalingMode: MANAGED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Dedicated IP Pool using the `pool_name`. For example:
 * ```sh
 * $ pulumi import aws:sesv2/dedicatedIpPool:DedicatedIpPool example my-pool
 * ```
 * @property poolName Name of the dedicated IP pool.
 * The following arguments are optional:
 * @property scalingMode IP pool scaling mode. Valid values: `STANDARD`, `MANAGED`. If omitted, the AWS API will default to a standard pool.
 * @property tags A map of tags to assign to the pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DedicatedIpPoolArgs(
    public val poolName: Output<String>? = null,
    public val scalingMode: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.DedicatedIpPoolArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.DedicatedIpPoolArgs =
        com.pulumi.aws.sesv2.DedicatedIpPoolArgs.builder()
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .scalingMode(scalingMode?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DedicatedIpPoolArgs].
 */
@PulumiTagMarker
public class DedicatedIpPoolArgsBuilder internal constructor() {
    private var poolName: Output<String>? = null

    private var scalingMode: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the dedicated IP pool.
     * The following arguments are optional:
     */
    @JvmName("sciawqvhqdjorvko")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value IP pool scaling mode. Valid values: `STANDARD`, `MANAGED`. If omitted, the AWS API will default to a standard pool.
     */
    @JvmName("wiebfkcqwkotabxs")
    public suspend fun scalingMode(`value`: Output<String>) {
        this.scalingMode = value
    }

    /**
     * @param value A map of tags to assign to the pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ioaqpfkkpgkrfepu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the dedicated IP pool.
     * The following arguments are optional:
     */
    @JvmName("rfpdjqnloraovtnh")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value IP pool scaling mode. Valid values: `STANDARD`, `MANAGED`. If omitted, the AWS API will default to a standard pool.
     */
    @JvmName("cwdjqykjduuiqfah")
    public suspend fun scalingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingMode = mapped
    }

    /**
     * @param value A map of tags to assign to the pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("umopvidqvuphjbsg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the pool. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tnkbbidwliejqxos")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DedicatedIpPoolArgs = DedicatedIpPoolArgs(
        poolName = poolName,
        scalingMode = scalingMode,
        tags = tags,
    )
}
