@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EmailIdentityMailFromAttributes].
 */
@PulumiTagMarker
public class EmailIdentityMailFromAttributesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EmailIdentityMailFromAttributesArgs = EmailIdentityMailFromAttributesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EmailIdentityMailFromAttributesArgsBuilder.() -> Unit) {
        val builder = EmailIdentityMailFromAttributesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EmailIdentityMailFromAttributes {
        val builtJavaResource =
            com.pulumi.aws.sesv2.EmailIdentityMailFromAttributes(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EmailIdentityMailFromAttributes(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Email Identity Mail From Attributes.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.EmailIdentity("example", {emailIdentity: "example.com"});
 * const exampleEmailIdentityMailFromAttributes = new aws.sesv2.EmailIdentityMailFromAttributes("example", {
 *     emailIdentity: example.emailIdentity,
 *     behaviorOnMxFailure: "REJECT_MESSAGE",
 *     mailFromDomain: pulumi.interpolate`subdomain.${example.emailIdentity}`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.EmailIdentity("example", email_identity="example.com")
 * example_email_identity_mail_from_attributes = aws.sesv2.EmailIdentityMailFromAttributes("example",
 *     email_identity=example.email_identity,
 *     behavior_on_mx_failure="REJECT_MESSAGE",
 *     mail_from_domain=example.email_identity.apply(lambda email_identity: f"subdomain.{email_identity}"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.EmailIdentity("example", new()
 *     {
 *         EmailIdentityDetails = "example.com",
 *     });
 *     var exampleEmailIdentityMailFromAttributes = new Aws.SesV2.EmailIdentityMailFromAttributes("example", new()
 *     {
 *         EmailIdentity = example.EmailIdentityDetails,
 *         BehaviorOnMxFailure = "REJECT_MESSAGE",
 *         MailFromDomain = example.EmailIdentityDetails.Apply(emailIdentity => $"subdomain.{emailIdentity}"),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := sesv2.NewEmailIdentity(ctx, "example", &sesv2.EmailIdentityArgs{
 * 			EmailIdentity: pulumi.String("example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sesv2.NewEmailIdentityMailFromAttributes(ctx, "example", &sesv2.EmailIdentityMailFromAttributesArgs{
 * 			EmailIdentity:       example.EmailIdentity,
 * 			BehaviorOnMxFailure: pulumi.String("REJECT_MESSAGE"),
 * 			MailFromDomain: example.EmailIdentity.ApplyT(func(emailIdentity string) (string, error) {
 * 				return fmt.Sprintf("subdomain.%v", emailIdentity), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import com.pulumi.aws.sesv2.EmailIdentityMailFromAttributes;
 * import com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .emailIdentity("example.com")
 *             .build());
 *         var exampleEmailIdentityMailFromAttributes = new EmailIdentityMailFromAttributes("exampleEmailIdentityMailFromAttributes", EmailIdentityMailFromAttributesArgs.builder()
 *             .emailIdentity(example.emailIdentity())
 *             .behaviorOnMxFailure("REJECT_MESSAGE")
 *             .mailFromDomain(example.emailIdentity().applyValue(emailIdentity -> String.format("subdomain.%s", emailIdentity)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:EmailIdentity
 *     properties:
 *       emailIdentity: example.com
 *   exampleEmailIdentityMailFromAttributes:
 *     type: aws:sesv2:EmailIdentityMailFromAttributes
 *     name: example
 *     properties:
 *       emailIdentity: ${example.emailIdentity}
 *       behaviorOnMxFailure: REJECT_MESSAGE
 *       mailFromDomain: subdomain.${example.emailIdentity}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Email Identity Mail From Attributes using the `email_identity`. For example:
 * ```sh
 * $ pulumi import aws:sesv2/emailIdentityMailFromAttributes:EmailIdentityMailFromAttributes example example.com
 * ```
 */
public class EmailIdentityMailFromAttributes internal constructor(
    override val javaResource: com.pulumi.aws.sesv2.EmailIdentityMailFromAttributes,
) : KotlinCustomResource(javaResource, EmailIdentityMailFromAttributesMapper) {
    /**
     * The action to take if the required MX record isn't found when you send an email. Valid values: `USE_DEFAULT_VALUE`, `REJECT_MESSAGE`.
     */
    public val behaviorOnMxFailure: Output<String>?
        get() = javaResource.behaviorOnMxFailure().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The verified email identity.
     */
    public val emailIdentity: Output<String>
        get() = javaResource.emailIdentity().applyValue({ args0 -> args0 })

    /**
     * The custom MAIL FROM domain that you want the verified identity to use. Required if `behavior_on_mx_failure` is `REJECT_MESSAGE`.
     */
    public val mailFromDomain: Output<String>?
        get() = javaResource.mailFromDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object EmailIdentityMailFromAttributesMapper :
    ResourceMapper<EmailIdentityMailFromAttributes> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sesv2.EmailIdentityMailFromAttributes::class == javaResource::class

    override fun map(javaResource: Resource): EmailIdentityMailFromAttributes =
        EmailIdentityMailFromAttributes(
            javaResource as
                com.pulumi.aws.sesv2.EmailIdentityMailFromAttributes,
        )
}

/**
 * @see [EmailIdentityMailFromAttributes].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EmailIdentityMailFromAttributes].
 */
public suspend fun emailIdentityMailFromAttributes(
    name: String,
    block: suspend EmailIdentityMailFromAttributesResourceBuilder.() -> Unit,
): EmailIdentityMailFromAttributes {
    val builder = EmailIdentityMailFromAttributesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EmailIdentityMailFromAttributes].
 * @param name The _unique_ name of the resulting resource.
 */
public fun emailIdentityMailFromAttributes(name: String): EmailIdentityMailFromAttributes {
    val builder = EmailIdentityMailFromAttributesResourceBuilder()
    builder.name(name)
    return builder.build()
}
