@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Email Identity Mail From Attributes.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.EmailIdentity("example", {emailIdentity: "example.com"});
 * const exampleEmailIdentityMailFromAttributes = new aws.sesv2.EmailIdentityMailFromAttributes("example", {
 *     emailIdentity: example.emailIdentity,
 *     behaviorOnMxFailure: "REJECT_MESSAGE",
 *     mailFromDomain: pulumi.interpolate`subdomain.${example.emailIdentity}`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.EmailIdentity("example", email_identity="example.com")
 * example_email_identity_mail_from_attributes = aws.sesv2.EmailIdentityMailFromAttributes("example",
 *     email_identity=example.email_identity,
 *     behavior_on_mx_failure="REJECT_MESSAGE",
 *     mail_from_domain=example.email_identity.apply(lambda email_identity: f"subdomain.{email_identity}"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.EmailIdentity("example", new()
 *     {
 *         EmailIdentityDetails = "example.com",
 *     });
 *     var exampleEmailIdentityMailFromAttributes = new Aws.SesV2.EmailIdentityMailFromAttributes("example", new()
 *     {
 *         EmailIdentity = example.EmailIdentityDetails,
 *         BehaviorOnMxFailure = "REJECT_MESSAGE",
 *         MailFromDomain = example.EmailIdentityDetails.Apply(emailIdentity => $"subdomain.{emailIdentity}"),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := sesv2.NewEmailIdentity(ctx, "example", &sesv2.EmailIdentityArgs{
 * 			EmailIdentity: pulumi.String("example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sesv2.NewEmailIdentityMailFromAttributes(ctx, "example", &sesv2.EmailIdentityMailFromAttributesArgs{
 * 			EmailIdentity:       example.EmailIdentity,
 * 			BehaviorOnMxFailure: pulumi.String("REJECT_MESSAGE"),
 * 			MailFromDomain: example.EmailIdentity.ApplyT(func(emailIdentity string) (string, error) {
 * 				return fmt.Sprintf("subdomain.%v", emailIdentity), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import com.pulumi.aws.sesv2.EmailIdentityMailFromAttributes;
 * import com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .emailIdentity("example.com")
 *             .build());
 *         var exampleEmailIdentityMailFromAttributes = new EmailIdentityMailFromAttributes("exampleEmailIdentityMailFromAttributes", EmailIdentityMailFromAttributesArgs.builder()
 *             .emailIdentity(example.emailIdentity())
 *             .behaviorOnMxFailure("REJECT_MESSAGE")
 *             .mailFromDomain(example.emailIdentity().applyValue(emailIdentity -> String.format("subdomain.%s", emailIdentity)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:EmailIdentity
 *     properties:
 *       emailIdentity: example.com
 *   exampleEmailIdentityMailFromAttributes:
 *     type: aws:sesv2:EmailIdentityMailFromAttributes
 *     name: example
 *     properties:
 *       emailIdentity: ${example.emailIdentity}
 *       behaviorOnMxFailure: REJECT_MESSAGE
 *       mailFromDomain: subdomain.${example.emailIdentity}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Email Identity Mail From Attributes using the `email_identity`. For example:
 * ```sh
 * $ pulumi import aws:sesv2/emailIdentityMailFromAttributes:EmailIdentityMailFromAttributes example example.com
 * ```
 * @property behaviorOnMxFailure The action to take if the required MX record isn't found when you send an email. Valid values: `USE_DEFAULT_VALUE`, `REJECT_MESSAGE`.
 * @property emailIdentity The verified email identity.
 * @property mailFromDomain The custom MAIL FROM domain that you want the verified identity to use. Required if `behavior_on_mx_failure` is `REJECT_MESSAGE`.
 */
public data class EmailIdentityMailFromAttributesArgs(
    public val behaviorOnMxFailure: Output<String>? = null,
    public val emailIdentity: Output<String>? = null,
    public val mailFromDomain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs =
        com.pulumi.aws.sesv2.EmailIdentityMailFromAttributesArgs.builder()
            .behaviorOnMxFailure(behaviorOnMxFailure?.applyValue({ args0 -> args0 }))
            .emailIdentity(emailIdentity?.applyValue({ args0 -> args0 }))
            .mailFromDomain(mailFromDomain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EmailIdentityMailFromAttributesArgs].
 */
@PulumiTagMarker
public class EmailIdentityMailFromAttributesArgsBuilder internal constructor() {
    private var behaviorOnMxFailure: Output<String>? = null

    private var emailIdentity: Output<String>? = null

    private var mailFromDomain: Output<String>? = null

    /**
     * @param value The action to take if the required MX record isn't found when you send an email. Valid values: `USE_DEFAULT_VALUE`, `REJECT_MESSAGE`.
     */
    @JvmName("bdnrnxlmwxkbllfe")
    public suspend fun behaviorOnMxFailure(`value`: Output<String>) {
        this.behaviorOnMxFailure = value
    }

    /**
     * @param value The verified email identity.
     */
    @JvmName("jedhpswqystkgbqy")
    public suspend fun emailIdentity(`value`: Output<String>) {
        this.emailIdentity = value
    }

    /**
     * @param value The custom MAIL FROM domain that you want the verified identity to use. Required if `behavior_on_mx_failure` is `REJECT_MESSAGE`.
     */
    @JvmName("kiuaxjaamwrmvrmb")
    public suspend fun mailFromDomain(`value`: Output<String>) {
        this.mailFromDomain = value
    }

    /**
     * @param value The action to take if the required MX record isn't found when you send an email. Valid values: `USE_DEFAULT_VALUE`, `REJECT_MESSAGE`.
     */
    @JvmName("yqesbinxyyybfrcw")
    public suspend fun behaviorOnMxFailure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.behaviorOnMxFailure = mapped
    }

    /**
     * @param value The verified email identity.
     */
    @JvmName("kcovphxwrkscgwgr")
    public suspend fun emailIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailIdentity = mapped
    }

    /**
     * @param value The custom MAIL FROM domain that you want the verified identity to use. Required if `behavior_on_mx_failure` is `REJECT_MESSAGE`.
     */
    @JvmName("rellsepkcmksgfvt")
    public suspend fun mailFromDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mailFromDomain = mapped
    }

    internal fun build(): EmailIdentityMailFromAttributesArgs = EmailIdentityMailFromAttributesArgs(
        behaviorOnMxFailure = behaviorOnMxFailure,
        emailIdentity = emailIdentity,
        mailFromDomain = mailFromDomain,
    )
}
