@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EmailIdentityPolicy].
 */
@PulumiTagMarker
public class EmailIdentityPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EmailIdentityPolicyArgs = EmailIdentityPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EmailIdentityPolicyArgsBuilder.() -> Unit) {
        val builder = EmailIdentityPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EmailIdentityPolicy {
        val builtJavaResource = com.pulumi.aws.sesv2.EmailIdentityPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EmailIdentityPolicy(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Email Identity Policy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.EmailIdentity("example", {emailIdentity: "testing@example.com"});
 * const exampleEmailIdentityPolicy = new aws.sesv2.EmailIdentityPolicy("example", {
 *     emailIdentity: example.emailIdentity,
 *     policyName: "example",
 *     policy: pulumi.interpolate`{
 *   "Id":"ExampleAuthorizationPolicy",
 *   "Version":"2012-10-17",
 *   "Statement":[
 *     {
 *       "Sid":"AuthorizeIAMUser",
 *       "Effect":"Allow",
 *       "Resource":"${example.arn}",
 *       "Principal":{
 *         "AWS":[
 *           "arn:aws:iam::123456789012:user/John",
 *           "arn:aws:iam::123456789012:user/Jane"
 *         ]
 *       },
 *       "Action":[
 *         "ses:DeleteEmailIdentity",
 *         "ses:PutEmailIdentityDkimSigningAttributes"
 *       ]
 *     }
 *   ]
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.EmailIdentity("example", email_identity="testing@example.com")
 * example_email_identity_policy = aws.sesv2.EmailIdentityPolicy("example",
 *     email_identity=example.email_identity,
 *     policy_name="example",
 *     policy=example.arn.apply(lambda arn: f"""{{
 *   "Id":"ExampleAuthorizationPolicy",
 *   "Version":"2012-10-17",
 *   "Statement":[
 *     {{
 *       "Sid":"AuthorizeIAMUser",
 *       "Effect":"Allow",
 *       "Resource":"{arn}",
 *       "Principal":{{
 *         "AWS":[
 *           "arn:aws:iam::123456789012:user/John",
 *           "arn:aws:iam::123456789012:user/Jane"
 *         ]
 *       }},
 *       "Action":[
 *         "ses:DeleteEmailIdentity",
 *         "ses:PutEmailIdentityDkimSigningAttributes"
 *       ]
 *     }}
 *   ]
 * }}
 * """))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.EmailIdentity("example", new()
 *     {
 *         EmailIdentityDetails = "testing@example.com",
 *     });
 *     var exampleEmailIdentityPolicy = new Aws.SesV2.EmailIdentityPolicy("example", new()
 *     {
 *         EmailIdentity = example.EmailIdentityDetails,
 *         PolicyName = "example",
 *         Policy = example.Arn.Apply(arn => @$"{{
 *   ""Id"":""ExampleAuthorizationPolicy"",
 *   ""Version"":""2012-10-17"",
 *   ""Statement"":[
 *     {{
 *       ""Sid"":""AuthorizeIAMUser"",
 *       ""Effect"":""Allow"",
 *       ""Resource"":""{arn}"",
 *       ""Principal"":{{
 *         ""AWS"":[
 *           ""arn:aws:iam::123456789012:user/John"",
 *           ""arn:aws:iam::123456789012:user/Jane""
 *         ]
 *       }},
 *       ""Action"":[
 *         ""ses:DeleteEmailIdentity"",
 *         ""ses:PutEmailIdentityDkimSigningAttributes""
 *       ]
 *     }}
 *   ]
 * }}
 * "),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := sesv2.NewEmailIdentity(ctx, "example", &sesv2.EmailIdentityArgs{
 * 			EmailIdentity: pulumi.String("testing@example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sesv2.NewEmailIdentityPolicy(ctx, "example", &sesv2.EmailIdentityPolicyArgs{
 * 			EmailIdentity: example.EmailIdentity,
 * 			PolicyName:    pulumi.String("example"),
 * 			Policy: example.Arn.ApplyT(func(arn string) (string, error) {
 * 				return fmt.Sprintf(`{
 *   "Id":"ExampleAuthorizationPolicy",
 *   "Version":"2012-10-17",
 *   "Statement":[
 *     {
 *       "Sid":"AuthorizeIAMUser",
 *       "Effect":"Allow",
 *       "Resource":"%v",
 *       "Principal":{
 *         "AWS":[
 *           "arn:aws:iam::123456789012:user/John",
 *           "arn:aws:iam::123456789012:user/Jane"
 *         ]
 *       },
 *       "Action":[
 *         "ses:DeleteEmailIdentity",
 *         "ses:PutEmailIdentityDkimSigningAttributes"
 *       ]
 *     }
 *   ]
 * }
 * `, arn), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import com.pulumi.aws.sesv2.EmailIdentityPolicy;
 * import com.pulumi.aws.sesv2.EmailIdentityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .emailIdentity("testing@example.com")
 *             .build());
 *         var exampleEmailIdentityPolicy = new EmailIdentityPolicy("exampleEmailIdentityPolicy", EmailIdentityPolicyArgs.builder()
 *             .emailIdentity(example.emailIdentity())
 *             .policyName("example")
 *             .policy(example.arn().applyValue(arn -> """
 * {
 *   "Id":"ExampleAuthorizationPolicy",
 *   "Version":"2012-10-17",
 *   "Statement":[
 *     {
 *       "Sid":"AuthorizeIAMUser",
 *       "Effect":"Allow",
 *       "Resource":"%s",
 *       "Principal":{
 *         "AWS":[
 *           "arn:aws:iam::123456789012:user/John",
 *           "arn:aws:iam::123456789012:user/Jane"
 *         ]
 *       },
 *       "Action":[
 *         "ses:DeleteEmailIdentity",
 *         "ses:PutEmailIdentityDkimSigningAttributes"
 *       ]
 *     }
 *   ]
 * }
 * ", arn)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:EmailIdentity
 *     properties:
 *       emailIdentity: testing@example.com
 *   exampleEmailIdentityPolicy:
 *     type: aws:sesv2:EmailIdentityPolicy
 *     name: example
 *     properties:
 *       emailIdentity: ${example.emailIdentity}
 *       policyName: example
 *       policy: |
 *         {
 *           "Id":"ExampleAuthorizationPolicy",
 *           "Version":"2012-10-17",
 *           "Statement":[
 *             {
 *               "Sid":"AuthorizeIAMUser",
 *               "Effect":"Allow",
 *               "Resource":"${example.arn}",
 *               "Principal":{
 *                 "AWS":[
 *                   "arn:aws:iam::123456789012:user/John",
 *                   "arn:aws:iam::123456789012:user/Jane"
 *                 ]
 *               },
 *               "Action":[
 *                 "ses:DeleteEmailIdentity",
 *                 "ses:PutEmailIdentityDkimSigningAttributes"
 *               ]
 *             }
 *           ]
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Email Identity Policy using the `example_id_arg`. For example:
 * ```sh
 * $ pulumi import aws:sesv2/emailIdentityPolicy:EmailIdentityPolicy example example_email_identity|example_policy_name
 * ```
 */
public class EmailIdentityPolicy internal constructor(
    override val javaResource: com.pulumi.aws.sesv2.EmailIdentityPolicy,
) : KotlinCustomResource(javaResource, EmailIdentityPolicyMapper) {
    /**
     * The email identity.
     */
    public val emailIdentity: Output<String>
        get() = javaResource.emailIdentity().applyValue({ args0 -> args0 })

    /**
     * The text of the policy in JSON format.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The name of the policy.
     */
    public val policyName: Output<String>
        get() = javaResource.policyName().applyValue({ args0 -> args0 })
}

public object EmailIdentityPolicyMapper : ResourceMapper<EmailIdentityPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sesv2.EmailIdentityPolicy::class == javaResource::class

    override fun map(javaResource: Resource): EmailIdentityPolicy = EmailIdentityPolicy(
        javaResource
            as com.pulumi.aws.sesv2.EmailIdentityPolicy,
    )
}

/**
 * @see [EmailIdentityPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EmailIdentityPolicy].
 */
public suspend fun emailIdentityPolicy(
    name: String,
    block: suspend EmailIdentityPolicyResourceBuilder.() -> Unit,
): EmailIdentityPolicy {
    val builder = EmailIdentityPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EmailIdentityPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun emailIdentityPolicy(name: String): EmailIdentityPolicy {
    val builder = EmailIdentityPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
