@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin

import com.pulumi.aws.sesv2.EmailIdentityPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SESv2 (Simple Email V2) Email Identity Policy.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sesv2.EmailIdentity("example", {emailIdentity: "testing@example.com"});
 * const exampleEmailIdentityPolicy = new aws.sesv2.EmailIdentityPolicy("example", {
 *     emailIdentity: example.emailIdentity,
 *     policyName: "example",
 *     policy: pulumi.interpolate`{
 *   "Id":"ExampleAuthorizationPolicy",
 *   "Version":"2012-10-17",
 *   "Statement":[
 *     {
 *       "Sid":"AuthorizeIAMUser",
 *       "Effect":"Allow",
 *       "Resource":"${example.arn}",
 *       "Principal":{
 *         "AWS":[
 *           "arn:aws:iam::123456789012:user/John",
 *           "arn:aws:iam::123456789012:user/Jane"
 *         ]
 *       },
 *       "Action":[
 *         "ses:DeleteEmailIdentity",
 *         "ses:PutEmailIdentityDkimSigningAttributes"
 *       ]
 *     }
 *   ]
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sesv2.EmailIdentity("example", email_identity="testing@example.com")
 * example_email_identity_policy = aws.sesv2.EmailIdentityPolicy("example",
 *     email_identity=example.email_identity,
 *     policy_name="example",
 *     policy=example.arn.apply(lambda arn: f"""{{
 *   "Id":"ExampleAuthorizationPolicy",
 *   "Version":"2012-10-17",
 *   "Statement":[
 *     {{
 *       "Sid":"AuthorizeIAMUser",
 *       "Effect":"Allow",
 *       "Resource":"{arn}",
 *       "Principal":{{
 *         "AWS":[
 *           "arn:aws:iam::123456789012:user/John",
 *           "arn:aws:iam::123456789012:user/Jane"
 *         ]
 *       }},
 *       "Action":[
 *         "ses:DeleteEmailIdentity",
 *         "ses:PutEmailIdentityDkimSigningAttributes"
 *       ]
 *     }}
 *   ]
 * }}
 * """))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SesV2.EmailIdentity("example", new()
 *     {
 *         EmailIdentityDetails = "testing@example.com",
 *     });
 *     var exampleEmailIdentityPolicy = new Aws.SesV2.EmailIdentityPolicy("example", new()
 *     {
 *         EmailIdentity = example.EmailIdentityDetails,
 *         PolicyName = "example",
 *         Policy = example.Arn.Apply(arn => @$"{{
 *   ""Id"":""ExampleAuthorizationPolicy"",
 *   ""Version"":""2012-10-17"",
 *   ""Statement"":[
 *     {{
 *       ""Sid"":""AuthorizeIAMUser"",
 *       ""Effect"":""Allow"",
 *       ""Resource"":""{arn}"",
 *       ""Principal"":{{
 *         ""AWS"":[
 *           ""arn:aws:iam::123456789012:user/John"",
 *           ""arn:aws:iam::123456789012:user/Jane""
 *         ]
 *       }},
 *       ""Action"":[
 *         ""ses:DeleteEmailIdentity"",
 *         ""ses:PutEmailIdentityDkimSigningAttributes""
 *       ]
 *     }}
 *   ]
 * }}
 * "),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sesv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := sesv2.NewEmailIdentity(ctx, "example", &sesv2.EmailIdentityArgs{
 * 			EmailIdentity: pulumi.String("testing@example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sesv2.NewEmailIdentityPolicy(ctx, "example", &sesv2.EmailIdentityPolicyArgs{
 * 			EmailIdentity: example.EmailIdentity,
 * 			PolicyName:    pulumi.String("example"),
 * 			Policy: example.Arn.ApplyT(func(arn string) (string, error) {
 * 				return fmt.Sprintf(`{
 *   "Id":"ExampleAuthorizationPolicy",
 *   "Version":"2012-10-17",
 *   "Statement":[
 *     {
 *       "Sid":"AuthorizeIAMUser",
 *       "Effect":"Allow",
 *       "Resource":"%v",
 *       "Principal":{
 *         "AWS":[
 *           "arn:aws:iam::123456789012:user/John",
 *           "arn:aws:iam::123456789012:user/Jane"
 *         ]
 *       },
 *       "Action":[
 *         "ses:DeleteEmailIdentity",
 *         "ses:PutEmailIdentityDkimSigningAttributes"
 *       ]
 *     }
 *   ]
 * }
 * `, arn), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sesv2.EmailIdentity;
 * import com.pulumi.aws.sesv2.EmailIdentityArgs;
 * import com.pulumi.aws.sesv2.EmailIdentityPolicy;
 * import com.pulumi.aws.sesv2.EmailIdentityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .emailIdentity("testing@example.com")
 *             .build());
 *         var exampleEmailIdentityPolicy = new EmailIdentityPolicy("exampleEmailIdentityPolicy", EmailIdentityPolicyArgs.builder()
 *             .emailIdentity(example.emailIdentity())
 *             .policyName("example")
 *             .policy(example.arn().applyValue(arn -> """
 * {
 *   "Id":"ExampleAuthorizationPolicy",
 *   "Version":"2012-10-17",
 *   "Statement":[
 *     {
 *       "Sid":"AuthorizeIAMUser",
 *       "Effect":"Allow",
 *       "Resource":"%s",
 *       "Principal":{
 *         "AWS":[
 *           "arn:aws:iam::123456789012:user/John",
 *           "arn:aws:iam::123456789012:user/Jane"
 *         ]
 *       },
 *       "Action":[
 *         "ses:DeleteEmailIdentity",
 *         "ses:PutEmailIdentityDkimSigningAttributes"
 *       ]
 *     }
 *   ]
 * }
 * ", arn)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sesv2:EmailIdentity
 *     properties:
 *       emailIdentity: testing@example.com
 *   exampleEmailIdentityPolicy:
 *     type: aws:sesv2:EmailIdentityPolicy
 *     name: example
 *     properties:
 *       emailIdentity: ${example.emailIdentity}
 *       policyName: example
 *       policy: |
 *         {
 *           "Id":"ExampleAuthorizationPolicy",
 *           "Version":"2012-10-17",
 *           "Statement":[
 *             {
 *               "Sid":"AuthorizeIAMUser",
 *               "Effect":"Allow",
 *               "Resource":"${example.arn}",
 *               "Principal":{
 *                 "AWS":[
 *                   "arn:aws:iam::123456789012:user/John",
 *                   "arn:aws:iam::123456789012:user/Jane"
 *                 ]
 *               },
 *               "Action":[
 *                 "ses:DeleteEmailIdentity",
 *                 "ses:PutEmailIdentityDkimSigningAttributes"
 *               ]
 *             }
 *           ]
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SESv2 (Simple Email V2) Email Identity Policy using the `example_id_arg`. For example:
 * ```sh
 * $ pulumi import aws:sesv2/emailIdentityPolicy:EmailIdentityPolicy example example_email_identity|example_policy_name
 * ```
 * @property emailIdentity The email identity.
 * @property policy The text of the policy in JSON format.
 * @property policyName The name of the policy.
 */
public data class EmailIdentityPolicyArgs(
    public val emailIdentity: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val policyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.EmailIdentityPolicyArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.EmailIdentityPolicyArgs =
        com.pulumi.aws.sesv2.EmailIdentityPolicyArgs.builder()
            .emailIdentity(emailIdentity?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EmailIdentityPolicyArgs].
 */
@PulumiTagMarker
public class EmailIdentityPolicyArgsBuilder internal constructor() {
    private var emailIdentity: Output<String>? = null

    private var policy: Output<String>? = null

    private var policyName: Output<String>? = null

    /**
     * @param value The email identity.
     */
    @JvmName("rcvenvjrdgntuetx")
    public suspend fun emailIdentity(`value`: Output<String>) {
        this.emailIdentity = value
    }

    /**
     * @param value The text of the policy in JSON format.
     */
    @JvmName("canruirrinextplr")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("jxnlhdhggdrcrlhm")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The email identity.
     */
    @JvmName("glfhgruhweouavwk")
    public suspend fun emailIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailIdentity = mapped
    }

    /**
     * @param value The text of the policy in JSON format.
     */
    @JvmName("usftdwslnfbhwmlq")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The name of the policy.
     */
    @JvmName("xlolwhridxpornnt")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    internal fun build(): EmailIdentityPolicyArgs = EmailIdentityPolicyArgs(
        emailIdentity = emailIdentity,
        policy = policy,
        policyName = policyName,
    )
}
