@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.AccountVdmAttributesGuardianAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property optimizedSharedDelivery Specifies the status of your VDM optimized shared delivery. Valid values: `ENABLED`, `DISABLED`.
 */
public data class AccountVdmAttributesGuardianAttributesArgs(
    public val optimizedSharedDelivery: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.AccountVdmAttributesGuardianAttributesArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.AccountVdmAttributesGuardianAttributesArgs =
        com.pulumi.aws.sesv2.inputs.AccountVdmAttributesGuardianAttributesArgs.builder()
            .optimizedSharedDelivery(optimizedSharedDelivery?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountVdmAttributesGuardianAttributesArgs].
 */
@PulumiTagMarker
public class AccountVdmAttributesGuardianAttributesArgsBuilder internal constructor() {
    private var optimizedSharedDelivery: Output<String>? = null

    /**
     * @param value Specifies the status of your VDM optimized shared delivery. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("uupuhodcqxwsjxrn")
    public suspend fun optimizedSharedDelivery(`value`: Output<String>) {
        this.optimizedSharedDelivery = value
    }

    /**
     * @param value Specifies the status of your VDM optimized shared delivery. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("cpoxrhrbribroged")
    public suspend fun optimizedSharedDelivery(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizedSharedDelivery = mapped
    }

    internal fun build(): AccountVdmAttributesGuardianAttributesArgs =
        AccountVdmAttributesGuardianAttributesArgs(
            optimizedSharedDelivery = optimizedSharedDelivery,
        )
}
