@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dimensionConfigurations An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch. See `dimension_configuration` Block for details.
 */
public data class ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs(
    public val dimensionConfigurations: Output<List<ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs.builder()
            .dimensionConfigurations(
                dimensionConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs].
 */
@PulumiTagMarker
public class ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgsBuilder
internal constructor() {
    private var dimensionConfigurations:
        Output<List<ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs>>? =
        null

    /**
     * @param value An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch. See `dimension_configuration` Block for details.
     */
    @JvmName("ydkergibnulplesc")
    public suspend fun dimensionConfigurations(`value`: Output<List<ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs>>) {
        this.dimensionConfigurations = value
    }

    @JvmName("rktuopuespomycpc")
    public suspend fun dimensionConfigurations(vararg values: Output<ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs>) {
        this.dimensionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch. See `dimension_configuration` Block for details.
     */
    @JvmName("wpoinxirpqtkfnxp")
    public suspend fun dimensionConfigurations(values: List<Output<ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs>>) {
        this.dimensionConfigurations = Output.all(values)
    }

    /**
     * @param value An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch. See `dimension_configuration` Block for details.
     */
    @JvmName("seogxgctdschoccv")
    public suspend fun dimensionConfigurations(`value`: List<ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensionConfigurations = mapped
    }

    /**
     * @param argument An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch. See `dimension_configuration` Block for details.
     */
    @JvmName("ihomidgmodupicrl")
    public suspend fun dimensionConfigurations(argument: List<suspend ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensionConfigurations = mapped
    }

    /**
     * @param argument An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch. See `dimension_configuration` Block for details.
     */
    @JvmName("liqfdccfpjgwohsw")
    public suspend fun dimensionConfigurations(vararg argument: suspend ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensionConfigurations = mapped
    }

    /**
     * @param argument An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch. See `dimension_configuration` Block for details.
     */
    @JvmName("bujimsqogurvcicw")
    public suspend fun dimensionConfigurations(argument: suspend ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.dimensionConfigurations = mapped
    }

    /**
     * @param values An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch. See `dimension_configuration` Block for details.
     */
    @JvmName("cbrnqtuuywnodkib")
    public suspend fun dimensionConfigurations(vararg values: ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensionConfigurations = mapped
    }

    internal fun build(): ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs =
        ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationArgs(
            dimensionConfigurations = dimensionConfigurations ?: throw
                PulumiNullFieldException("dimensionConfigurations"),
        )
}
