@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultDimensionValue The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value of the dimension when you send an email.
 * @property dimensionName The name of an Amazon CloudWatch dimension associated with an email sending metric.
 * @property dimensionValueSource The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. Valid values: `MESSAGE_TAG`, `EMAIL_HEADER`, `LINK_TAG`.
 */
public data class
ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs(
    public val defaultDimensionValue: Output<String>,
    public val dimensionName: Output<String>,
    public val dimensionValueSource: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs.builder()
            .defaultDimensionValue(defaultDimensionValue.applyValue({ args0 -> args0 }))
            .dimensionName(dimensionName.applyValue({ args0 -> args0 }))
            .dimensionValueSource(dimensionValueSource.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs].
 */
@PulumiTagMarker
public class
ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgsBuilder
internal constructor() {
    private var defaultDimensionValue: Output<String>? = null

    private var dimensionName: Output<String>? = null

    private var dimensionValueSource: Output<String>? = null

    /**
     * @param value The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value of the dimension when you send an email.
     */
    @JvmName("nasbsodsqfsjcqsq")
    public suspend fun defaultDimensionValue(`value`: Output<String>) {
        this.defaultDimensionValue = value
    }

    /**
     * @param value The name of an Amazon CloudWatch dimension associated with an email sending metric.
     */
    @JvmName("vwaibvurlxkdhvdr")
    public suspend fun dimensionName(`value`: Output<String>) {
        this.dimensionName = value
    }

    /**
     * @param value The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. Valid values: `MESSAGE_TAG`, `EMAIL_HEADER`, `LINK_TAG`.
     */
    @JvmName("fnoekvcecjntjrog")
    public suspend fun dimensionValueSource(`value`: Output<String>) {
        this.dimensionValueSource = value
    }

    /**
     * @param value The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value of the dimension when you send an email.
     */
    @JvmName("jetsuysmilkifeve")
    public suspend fun defaultDimensionValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultDimensionValue = mapped
    }

    /**
     * @param value The name of an Amazon CloudWatch dimension associated with an email sending metric.
     */
    @JvmName("xtyqvdwalfmnlyfo")
    public suspend fun dimensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensionName = mapped
    }

    /**
     * @param value The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. Valid values: `MESSAGE_TAG`, `EMAIL_HEADER`, `LINK_TAG`.
     */
    @JvmName("bnksmkruvsfpndgm")
    public suspend fun dimensionValueSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensionValueSource = mapped
    }

    internal fun build(): ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs =
        ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfigurationArgs(
            defaultDimensionValue = defaultDimensionValue ?: throw
                PulumiNullFieldException("defaultDimensionValue"),
            dimensionName = dimensionName ?: throw PulumiNullFieldException("dimensionName"),
            dimensionValueSource = dimensionValueSource ?: throw
                PulumiNullFieldException("dimensionValueSource"),
        )
}
