@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationEventBridgeDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventBusArn The Amazon Resource Name (ARN) of the Amazon EventBridge bus to publish email events to. Only the default bus is supported.
 */
public data class ConfigurationSetEventDestinationEventDestinationEventBridgeDestinationArgs(
    public val eventBusArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationEventBridgeDestinationArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationEventBridgeDestinationArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationEventBridgeDestinationArgs.builder()
            .eventBusArn(eventBusArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetEventDestinationEventDestinationEventBridgeDestinationArgs].
 */
@PulumiTagMarker
public class ConfigurationSetEventDestinationEventDestinationEventBridgeDestinationArgsBuilder
internal constructor() {
    private var eventBusArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon EventBridge bus to publish email events to. Only the default bus is supported.
     */
    @JvmName("jqfsxpcrhrvkvash")
    public suspend fun eventBusArn(`value`: Output<String>) {
        this.eventBusArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon EventBridge bus to publish email events to. Only the default bus is supported.
     */
    @JvmName("logmstnylmavgsgo")
    public suspend fun eventBusArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventBusArn = mapped
    }

    internal fun build(): ConfigurationSetEventDestinationEventDestinationEventBridgeDestinationArgs =
        ConfigurationSetEventDestinationEventDestinationEventBridgeDestinationArgs(
            eventBusArn = eventBusArn ?: throw PulumiNullFieldException("eventBusArn"),
        )
}
