@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property topicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to publish email events to.
 */
public data class ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs(
    public val topicArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs.builder()
            .topicArn(topicArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs].
 */
@PulumiTagMarker
public class ConfigurationSetEventDestinationEventDestinationSnsDestinationArgsBuilder internal constructor() {
    private var topicArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon SNS topic to publish email events to.
     */
    @JvmName("hpxayuylqopnlbrj")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon SNS topic to publish email events to.
     */
    @JvmName("xnlfnenerwroxddw")
    public suspend fun topicArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs =
        ConfigurationSetEventDestinationEventDestinationSnsDestinationArgs(
            topicArn = topicArn ?: throw PulumiNullFieldException("topicArn"),
        )
}
