@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetReputationOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lastFreshStart The date and time (in Unix time) when the reputation metrics were last given a fresh start. When your account is given a fresh start, your reputation metrics are calculated starting from the date of the fresh start.
 * @property reputationMetricsEnabled If `true`, tracking of reputation metrics is enabled for the configuration set. If `false`, tracking of reputation metrics is disabled for the configuration set.
 */
public data class ConfigurationSetReputationOptionsArgs(
    public val lastFreshStart: Output<String>? = null,
    public val reputationMetricsEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetReputationOptionsArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ConfigurationSetReputationOptionsArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetReputationOptionsArgs.builder()
            .lastFreshStart(lastFreshStart?.applyValue({ args0 -> args0 }))
            .reputationMetricsEnabled(reputationMetricsEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetReputationOptionsArgs].
 */
@PulumiTagMarker
public class ConfigurationSetReputationOptionsArgsBuilder internal constructor() {
    private var lastFreshStart: Output<String>? = null

    private var reputationMetricsEnabled: Output<Boolean>? = null

    /**
     * @param value The date and time (in Unix time) when the reputation metrics were last given a fresh start. When your account is given a fresh start, your reputation metrics are calculated starting from the date of the fresh start.
     */
    @JvmName("njrrcrxtybeorsam")
    public suspend fun lastFreshStart(`value`: Output<String>) {
        this.lastFreshStart = value
    }

    /**
     * @param value If `true`, tracking of reputation metrics is enabled for the configuration set. If `false`, tracking of reputation metrics is disabled for the configuration set.
     */
    @JvmName("yeqcppwxcqeshjrm")
    public suspend fun reputationMetricsEnabled(`value`: Output<Boolean>) {
        this.reputationMetricsEnabled = value
    }

    /**
     * @param value The date and time (in Unix time) when the reputation metrics were last given a fresh start. When your account is given a fresh start, your reputation metrics are calculated starting from the date of the fresh start.
     */
    @JvmName("eqyutvysglrvjyda")
    public suspend fun lastFreshStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastFreshStart = mapped
    }

    /**
     * @param value If `true`, tracking of reputation metrics is enabled for the configuration set. If `false`, tracking of reputation metrics is disabled for the configuration set.
     */
    @JvmName("ofumelynkricgqet")
    public suspend fun reputationMetricsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reputationMetricsEnabled = mapped
    }

    internal fun build(): ConfigurationSetReputationOptionsArgs =
        ConfigurationSetReputationOptionsArgs(
            lastFreshStart = lastFreshStart,
            reputationMetricsEnabled = reputationMetricsEnabled,
        )
}
