@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetSendingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property sendingEnabled If `true`, email sending is enabled for the configuration set. If `false`, email sending is disabled for the configuration set.
 */
public data class ConfigurationSetSendingOptionsArgs(
    public val sendingEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetSendingOptionsArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ConfigurationSetSendingOptionsArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetSendingOptionsArgs.builder()
            .sendingEnabled(sendingEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetSendingOptionsArgs].
 */
@PulumiTagMarker
public class ConfigurationSetSendingOptionsArgsBuilder internal constructor() {
    private var sendingEnabled: Output<Boolean>? = null

    /**
     * @param value If `true`, email sending is enabled for the configuration set. If `false`, email sending is disabled for the configuration set.
     */
    @JvmName("bvuqeyulupovwjrh")
    public suspend fun sendingEnabled(`value`: Output<Boolean>) {
        this.sendingEnabled = value
    }

    /**
     * @param value If `true`, email sending is enabled for the configuration set. If `false`, email sending is disabled for the configuration set.
     */
    @JvmName("tjmiemoithadfebt")
    public suspend fun sendingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendingEnabled = mapped
    }

    internal fun build(): ConfigurationSetSendingOptionsArgs = ConfigurationSetSendingOptionsArgs(
        sendingEnabled = sendingEnabled,
    )
}
