@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetSuppressionOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property suppressedReasons A list that contains the reasons that email addresses are automatically added to the suppression list for your account. Valid values: `BOUNCE`, `COMPLAINT`.
 */
public data class ConfigurationSetSuppressionOptionsArgs(
    public val suppressedReasons: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetSuppressionOptionsArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ConfigurationSetSuppressionOptionsArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetSuppressionOptionsArgs.builder()
            .suppressedReasons(suppressedReasons?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ConfigurationSetSuppressionOptionsArgs].
 */
@PulumiTagMarker
public class ConfigurationSetSuppressionOptionsArgsBuilder internal constructor() {
    private var suppressedReasons: Output<List<String>>? = null

    /**
     * @param value A list that contains the reasons that email addresses are automatically added to the suppression list for your account. Valid values: `BOUNCE`, `COMPLAINT`.
     */
    @JvmName("aramjaaihudreloq")
    public suspend fun suppressedReasons(`value`: Output<List<String>>) {
        this.suppressedReasons = value
    }

    @JvmName("hvqipyrilbqxkhfe")
    public suspend fun suppressedReasons(vararg values: Output<String>) {
        this.suppressedReasons = Output.all(values.asList())
    }

    /**
     * @param values A list that contains the reasons that email addresses are automatically added to the suppression list for your account. Valid values: `BOUNCE`, `COMPLAINT`.
     */
    @JvmName("romwsynfcusmivve")
    public suspend fun suppressedReasons(values: List<Output<String>>) {
        this.suppressedReasons = Output.all(values)
    }

    /**
     * @param value A list that contains the reasons that email addresses are automatically added to the suppression list for your account. Valid values: `BOUNCE`, `COMPLAINT`.
     */
    @JvmName("rolilwymxohdfpyu")
    public suspend fun suppressedReasons(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressedReasons = mapped
    }

    /**
     * @param values A list that contains the reasons that email addresses are automatically added to the suppression list for your account. Valid values: `BOUNCE`, `COMPLAINT`.
     */
    @JvmName("ysgmuowsuekupwxk")
    public suspend fun suppressedReasons(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.suppressedReasons = mapped
    }

    internal fun build(): ConfigurationSetSuppressionOptionsArgs =
        ConfigurationSetSuppressionOptionsArgs(
            suppressedReasons = suppressedReasons,
        )
}
