@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetVdmOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dashboardOptions Specifies additional settings for your VDM configuration as applicable to the Dashboard. See `dashboard_options` Block for details.
 * @property guardianOptions Specifies additional settings for your VDM configuration as applicable to the Guardian. See `guardian_options` Block for details.
 */
public data class ConfigurationSetVdmOptionsArgs(
    public val dashboardOptions: Output<ConfigurationSetVdmOptionsDashboardOptionsArgs>? = null,
    public val guardianOptions: Output<ConfigurationSetVdmOptionsGuardianOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetVdmOptionsArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ConfigurationSetVdmOptionsArgs =
        com.pulumi.aws.sesv2.inputs.ConfigurationSetVdmOptionsArgs.builder()
            .dashboardOptions(dashboardOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .guardianOptions(
                guardianOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationSetVdmOptionsArgs].
 */
@PulumiTagMarker
public class ConfigurationSetVdmOptionsArgsBuilder internal constructor() {
    private var dashboardOptions: Output<ConfigurationSetVdmOptionsDashboardOptionsArgs>? = null

    private var guardianOptions: Output<ConfigurationSetVdmOptionsGuardianOptionsArgs>? = null

    /**
     * @param value Specifies additional settings for your VDM configuration as applicable to the Dashboard. See `dashboard_options` Block for details.
     */
    @JvmName("okislikbfqjqxify")
    public suspend fun dashboardOptions(`value`: Output<ConfigurationSetVdmOptionsDashboardOptionsArgs>) {
        this.dashboardOptions = value
    }

    /**
     * @param value Specifies additional settings for your VDM configuration as applicable to the Guardian. See `guardian_options` Block for details.
     */
    @JvmName("mrkjowlpadmirfll")
    public suspend fun guardianOptions(`value`: Output<ConfigurationSetVdmOptionsGuardianOptionsArgs>) {
        this.guardianOptions = value
    }

    /**
     * @param value Specifies additional settings for your VDM configuration as applicable to the Dashboard. See `dashboard_options` Block for details.
     */
    @JvmName("knjmknpnudmgnxxh")
    public suspend fun dashboardOptions(`value`: ConfigurationSetVdmOptionsDashboardOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardOptions = mapped
    }

    /**
     * @param argument Specifies additional settings for your VDM configuration as applicable to the Dashboard. See `dashboard_options` Block for details.
     */
    @JvmName("fsbvoxidysvdlboa")
    public suspend fun dashboardOptions(argument: suspend ConfigurationSetVdmOptionsDashboardOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationSetVdmOptionsDashboardOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dashboardOptions = mapped
    }

    /**
     * @param value Specifies additional settings for your VDM configuration as applicable to the Guardian. See `guardian_options` Block for details.
     */
    @JvmName("qhaumrtdhmxwevyo")
    public suspend fun guardianOptions(`value`: ConfigurationSetVdmOptionsGuardianOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guardianOptions = mapped
    }

    /**
     * @param argument Specifies additional settings for your VDM configuration as applicable to the Guardian. See `guardian_options` Block for details.
     */
    @JvmName("wpykfxrescgaethw")
    public suspend fun guardianOptions(argument: suspend ConfigurationSetVdmOptionsGuardianOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationSetVdmOptionsGuardianOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.guardianOptions = mapped
    }

    internal fun build(): ConfigurationSetVdmOptionsArgs = ConfigurationSetVdmOptionsArgs(
        dashboardOptions = dashboardOptions,
        guardianOptions = guardianOptions,
    )
}
