@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.ConfigurationSetVdmOptionsDashboardOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property engagementMetrics Specifies the status of your VDM engagement metrics collection. Valid values: `ENABLED`, `DISABLED`.
 */
public data class ConfigurationSetVdmOptionsDashboardOptionsArgs(
    public val engagementMetrics: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.ConfigurationSetVdmOptionsDashboardOptionsArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.ConfigurationSetVdmOptionsDashboardOptionsArgs = com.pulumi.aws.sesv2.inputs.ConfigurationSetVdmOptionsDashboardOptionsArgs.builder()
        .engagementMetrics(engagementMetrics?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationSetVdmOptionsDashboardOptionsArgs].
 */
@PulumiTagMarker
public class ConfigurationSetVdmOptionsDashboardOptionsArgsBuilder internal constructor() {
    private var engagementMetrics: Output<String>? = null

    /**
     * @param value Specifies the status of your VDM engagement metrics collection. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("maycfljpfntnnjoa")
    public suspend fun engagementMetrics(`value`: Output<String>) {
        this.engagementMetrics = value
    }

    /**
     * @param value Specifies the status of your VDM engagement metrics collection. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("vdwhvitdsfcdcixc")
    public suspend fun engagementMetrics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engagementMetrics = mapped
    }

    internal fun build(): ConfigurationSetVdmOptionsDashboardOptionsArgs =
        ConfigurationSetVdmOptionsDashboardOptionsArgs(
            engagementMetrics = engagementMetrics,
        )
}
