@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.EmailIdentityDkimSigningAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property currentSigningKeyLength [Easy DKIM] The key length of the DKIM key pair in use.
 * @property domainSigningPrivateKey [Bring Your Own DKIM] A private key that's used to generate a DKIM signature. The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
 * > **NOTE:** You have to delete the first and last lines ('-----BEGIN PRIVATE KEY-----' and '-----END PRIVATE KEY-----', respectively) of the generated private key. Additionally, you have to remove the line breaks in the generated private key. The resulting value is a string of characters with no spaces or line breaks.
 * @property domainSigningSelector [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
 * @property lastKeyGenerationTimestamp [Easy DKIM] The last time a key pair was generated for this identity.
 * @property nextSigningKeyLength [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day. Valid values: `RSA_1024_BIT`, `RSA_2048_BIT`.
 * @property signingAttributesOrigin A string that indicates how DKIM was configured for the identity. `AWS_SES` indicates that DKIM was configured for the identity by using Easy DKIM. `EXTERNAL` indicates that DKIM was configured for the identity by using Bring Your Own DKIM (BYODKIM).
 * @property status Describes whether or not Amazon SES has successfully located the DKIM records in the DNS records for the domain. See the [AWS SES API v2 Reference](https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_DkimAttributes.html#SES-Type-DkimAttributes-Status) for supported statuses.
 * @property tokens If you used Easy DKIM to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.
 */
public data class EmailIdentityDkimSigningAttributesArgs(
    public val currentSigningKeyLength: Output<String>? = null,
    public val domainSigningPrivateKey: Output<String>? = null,
    public val domainSigningSelector: Output<String>? = null,
    public val lastKeyGenerationTimestamp: Output<String>? = null,
    public val nextSigningKeyLength: Output<String>? = null,
    public val signingAttributesOrigin: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tokens: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.EmailIdentityDkimSigningAttributesArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.EmailIdentityDkimSigningAttributesArgs =
        com.pulumi.aws.sesv2.inputs.EmailIdentityDkimSigningAttributesArgs.builder()
            .currentSigningKeyLength(currentSigningKeyLength?.applyValue({ args0 -> args0 }))
            .domainSigningPrivateKey(domainSigningPrivateKey?.applyValue({ args0 -> args0 }))
            .domainSigningSelector(domainSigningSelector?.applyValue({ args0 -> args0 }))
            .lastKeyGenerationTimestamp(lastKeyGenerationTimestamp?.applyValue({ args0 -> args0 }))
            .nextSigningKeyLength(nextSigningKeyLength?.applyValue({ args0 -> args0 }))
            .signingAttributesOrigin(signingAttributesOrigin?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tokens(tokens?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EmailIdentityDkimSigningAttributesArgs].
 */
@PulumiTagMarker
public class EmailIdentityDkimSigningAttributesArgsBuilder internal constructor() {
    private var currentSigningKeyLength: Output<String>? = null

    private var domainSigningPrivateKey: Output<String>? = null

    private var domainSigningSelector: Output<String>? = null

    private var lastKeyGenerationTimestamp: Output<String>? = null

    private var nextSigningKeyLength: Output<String>? = null

    private var signingAttributesOrigin: Output<String>? = null

    private var status: Output<String>? = null

    private var tokens: Output<List<String>>? = null

    /**
     * @param value [Easy DKIM] The key length of the DKIM key pair in use.
     */
    @JvmName("nqauujqyjqdtosxa")
    public suspend fun currentSigningKeyLength(`value`: Output<String>) {
        this.currentSigningKeyLength = value
    }

    /**
     * @param value [Bring Your Own DKIM] A private key that's used to generate a DKIM signature. The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
     * > **NOTE:** You have to delete the first and last lines ('-----BEGIN PRIVATE KEY-----' and '-----END PRIVATE KEY-----', respectively) of the generated private key. Additionally, you have to remove the line breaks in the generated private key. The resulting value is a string of characters with no spaces or line breaks.
     */
    @JvmName("envfupfhqvuxodim")
    public suspend fun domainSigningPrivateKey(`value`: Output<String>) {
        this.domainSigningPrivateKey = value
    }

    /**
     * @param value [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
     */
    @JvmName("rmukfpubllhjjsbe")
    public suspend fun domainSigningSelector(`value`: Output<String>) {
        this.domainSigningSelector = value
    }

    /**
     * @param value [Easy DKIM] The last time a key pair was generated for this identity.
     */
    @JvmName("lwsuxbkdgvdpixkc")
    public suspend fun lastKeyGenerationTimestamp(`value`: Output<String>) {
        this.lastKeyGenerationTimestamp = value
    }

    /**
     * @param value [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day. Valid values: `RSA_1024_BIT`, `RSA_2048_BIT`.
     */
    @JvmName("ejhuxrriwkhnrcfv")
    public suspend fun nextSigningKeyLength(`value`: Output<String>) {
        this.nextSigningKeyLength = value
    }

    /**
     * @param value A string that indicates how DKIM was configured for the identity. `AWS_SES` indicates that DKIM was configured for the identity by using Easy DKIM. `EXTERNAL` indicates that DKIM was configured for the identity by using Bring Your Own DKIM (BYODKIM).
     */
    @JvmName("cgjjfwqexnodssrd")
    public suspend fun signingAttributesOrigin(`value`: Output<String>) {
        this.signingAttributesOrigin = value
    }

    /**
     * @param value Describes whether or not Amazon SES has successfully located the DKIM records in the DNS records for the domain. See the [AWS SES API v2 Reference](https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_DkimAttributes.html#SES-Type-DkimAttributes-Status) for supported statuses.
     */
    @JvmName("dfojctfdjiojxwiu")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value If you used Easy DKIM to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.
     */
    @JvmName("hftpcqddladoxecq")
    public suspend fun tokens(`value`: Output<List<String>>) {
        this.tokens = value
    }

    @JvmName("tyarjlppgsbnfwdl")
    public suspend fun tokens(vararg values: Output<String>) {
        this.tokens = Output.all(values.asList())
    }

    /**
     * @param values If you used Easy DKIM to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.
     */
    @JvmName("gogwoueitsfawynx")
    public suspend fun tokens(values: List<Output<String>>) {
        this.tokens = Output.all(values)
    }

    /**
     * @param value [Easy DKIM] The key length of the DKIM key pair in use.
     */
    @JvmName("ccdrenneyapnrwlc")
    public suspend fun currentSigningKeyLength(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currentSigningKeyLength = mapped
    }

    /**
     * @param value [Bring Your Own DKIM] A private key that's used to generate a DKIM signature. The private key must use 1024 or 2048-bit RSA encryption, and must be encoded using base64 encoding.
     * > **NOTE:** You have to delete the first and last lines ('-----BEGIN PRIVATE KEY-----' and '-----END PRIVATE KEY-----', respectively) of the generated private key. Additionally, you have to remove the line breaks in the generated private key. The resulting value is a string of characters with no spaces or line breaks.
     */
    @JvmName("kditkfbwgangkvys")
    public suspend fun domainSigningPrivateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainSigningPrivateKey = mapped
    }

    /**
     * @param value [Bring Your Own DKIM] A string that's used to identify a public key in the DNS configuration for a domain.
     */
    @JvmName("tjhvijjcpuskcpsc")
    public suspend fun domainSigningSelector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainSigningSelector = mapped
    }

    /**
     * @param value [Easy DKIM] The last time a key pair was generated for this identity.
     */
    @JvmName("seesapggtdkvlrlb")
    public suspend fun lastKeyGenerationTimestamp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastKeyGenerationTimestamp = mapped
    }

    /**
     * @param value [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day. Valid values: `RSA_1024_BIT`, `RSA_2048_BIT`.
     */
    @JvmName("etkqfgnnvvbpggcp")
    public suspend fun nextSigningKeyLength(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextSigningKeyLength = mapped
    }

    /**
     * @param value A string that indicates how DKIM was configured for the identity. `AWS_SES` indicates that DKIM was configured for the identity by using Easy DKIM. `EXTERNAL` indicates that DKIM was configured for the identity by using Bring Your Own DKIM (BYODKIM).
     */
    @JvmName("qkapjsvubldsxppf")
    public suspend fun signingAttributesOrigin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingAttributesOrigin = mapped
    }

    /**
     * @param value Describes whether or not Amazon SES has successfully located the DKIM records in the DNS records for the domain. See the [AWS SES API v2 Reference](https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_DkimAttributes.html#SES-Type-DkimAttributes-Status) for supported statuses.
     */
    @JvmName("dwcggyeyjirvhsfk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value If you used Easy DKIM to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.
     */
    @JvmName("usdsakcuaiftafcc")
    public suspend fun tokens(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokens = mapped
    }

    /**
     * @param values If you used Easy DKIM to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.
     */
    @JvmName("twxainqvuxbwjqeu")
    public suspend fun tokens(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokens = mapped
    }

    internal fun build(): EmailIdentityDkimSigningAttributesArgs =
        EmailIdentityDkimSigningAttributesArgs(
            currentSigningKeyLength = currentSigningKeyLength,
            domainSigningPrivateKey = domainSigningPrivateKey,
            domainSigningSelector = domainSigningSelector,
            lastKeyGenerationTimestamp = lastKeyGenerationTimestamp,
            nextSigningKeyLength = nextSigningKeyLength,
            signingAttributesOrigin = signingAttributesOrigin,
            status = status,
            tokens = tokens,
        )
}
