@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.GetConfigurationSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConfigurationSet.
 * @property configurationSetName The name of the configuration set.
 * @property tags Key-value map of resource tags for the container recipe.
 */
public data class GetConfigurationSetPlainArgs(
    public val configurationSetName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.GetConfigurationSetPlainArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.GetConfigurationSetPlainArgs =
        com.pulumi.aws.sesv2.inputs.GetConfigurationSetPlainArgs.builder()
            .configurationSetName(configurationSetName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetConfigurationSetPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationSetPlainArgsBuilder internal constructor() {
    private var configurationSetName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The name of the configuration set.
     */
    @JvmName("ybtipolxaeynbosa")
    public suspend fun configurationSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationSetName = mapped
    }

    /**
     * @param value Key-value map of resource tags for the container recipe.
     */
    @JvmName("ravnwdsrwmnfdefj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the container recipe.
     */
    @JvmName("jgdgvivltncsqonv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetConfigurationSetPlainArgs = GetConfigurationSetPlainArgs(
        configurationSetName = configurationSetName ?: throw
            PulumiNullFieldException("configurationSetName"),
        tags = tags,
    )
}
