@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.GetEmailIdentityMailFromAttributesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEmailIdentityMailFromAttributes.
 * @property emailIdentity The name of the email identity.
 */
public data class GetEmailIdentityMailFromAttributesPlainArgs(
    public val emailIdentity: String,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.GetEmailIdentityMailFromAttributesPlainArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.GetEmailIdentityMailFromAttributesPlainArgs =
        com.pulumi.aws.sesv2.inputs.GetEmailIdentityMailFromAttributesPlainArgs.builder()
            .emailIdentity(emailIdentity.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEmailIdentityMailFromAttributesPlainArgs].
 */
@PulumiTagMarker
public class GetEmailIdentityMailFromAttributesPlainArgsBuilder internal constructor() {
    private var emailIdentity: String? = null

    /**
     * @param value The name of the email identity.
     */
    @JvmName("kphsuwsudhuccyrl")
    public suspend fun emailIdentity(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.emailIdentity = mapped
    }

    internal fun build(): GetEmailIdentityMailFromAttributesPlainArgs =
        GetEmailIdentityMailFromAttributesPlainArgs(
            emailIdentity = emailIdentity ?: throw PulumiNullFieldException("emailIdentity"),
        )
}
