@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.inputs

import com.pulumi.aws.sesv2.inputs.GetEmailIdentityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEmailIdentity.
 * @property emailIdentity The name of the email identity.
 * @property tags Key-value mapping of resource tags.
 */
public data class GetEmailIdentityPlainArgs(
    public val emailIdentity: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sesv2.inputs.GetEmailIdentityPlainArgs> {
    override fun toJava(): com.pulumi.aws.sesv2.inputs.GetEmailIdentityPlainArgs =
        com.pulumi.aws.sesv2.inputs.GetEmailIdentityPlainArgs.builder()
            .emailIdentity(emailIdentity.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetEmailIdentityPlainArgs].
 */
@PulumiTagMarker
public class GetEmailIdentityPlainArgsBuilder internal constructor() {
    private var emailIdentity: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The name of the email identity.
     */
    @JvmName("evnbtaifmgyscwxj")
    public suspend fun emailIdentity(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.emailIdentity = mapped
    }

    /**
     * @param value Key-value mapping of resource tags.
     */
    @JvmName("erhtoveqildbkbej")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags.
     */
    @JvmName("ybksblnmavulxrtl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetEmailIdentityPlainArgs = GetEmailIdentityPlainArgs(
        emailIdentity = emailIdentity ?: throw PulumiNullFieldException("emailIdentity"),
        tags = tags,
    )
}
