@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property sendingPoolName The name of the dedicated IP pool to associate with the configuration set.
 * @property tlsPolicy Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). Valid values: `REQUIRE`, `OPTIONAL`.
 */
public data class ConfigurationSetDeliveryOptions(
    public val sendingPoolName: String? = null,
    public val tlsPolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.ConfigurationSetDeliveryOptions): ConfigurationSetDeliveryOptions = ConfigurationSetDeliveryOptions(
            sendingPoolName = javaType.sendingPoolName().map({ args0 -> args0 }).orElse(null),
            tlsPolicy = javaType.tlsPolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
