@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultDimensionValue The default value of the dimension that is published to Amazon CloudWatch if you don't provide the value of the dimension when you send an email.
 * @property dimensionName The name of an Amazon CloudWatch dimension associated with an email sending metric.
 * @property dimensionValueSource The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. Valid values: `MESSAGE_TAG`, `EMAIL_HEADER`, `LINK_TAG`.
 */
public data class
ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfiguration(
    public val defaultDimensionValue: String,
    public val dimensionName: String,
    public val dimensionValueSource: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfiguration): ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfiguration =
            ConfigurationSetEventDestinationEventDestinationCloudWatchDestinationDimensionConfiguration(
                defaultDimensionValue = javaType.defaultDimensionValue(),
                dimensionName = javaType.dimensionName(),
                dimensionValueSource = javaType.dimensionValueSource(),
            )
    }
}
