@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deliveryStreamArn The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that the Amazon SES API v2 sends email events to.
 * @property iamRoleArn The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email events to the Amazon Kinesis Data Firehose stream.
 */
public data class ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestination(
    public val deliveryStreamArn: String,
    public val iamRoleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestination): ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestination =
            ConfigurationSetEventDestinationEventDestinationKinesisFirehoseDestination(
                deliveryStreamArn = javaType.deliveryStreamArn(),
                iamRoleArn = javaType.iamRoleArn(),
            )
    }
}
