@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property sendingPoolName The name of the dedicated IP pool to associate with the configuration set.
 * @property tlsPolicy Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
 */
public data class GetConfigurationSetDeliveryOption(
    public val sendingPoolName: String,
    public val tlsPolicy: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.GetConfigurationSetDeliveryOption): GetConfigurationSetDeliveryOption = GetConfigurationSetDeliveryOption(
            sendingPoolName = javaType.sendingPoolName(),
            tlsPolicy = javaType.tlsPolicy(),
        )
    }
}
