@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dashboardOptions Specifies additional settings for your VDM configuration as applicable to the Dashboard.
 * @property guardianOptions Specifies additional settings for your VDM configuration as applicable to the Guardian.
 */
public data class GetConfigurationSetVdmOption(
    public val dashboardOptions: List<GetConfigurationSetVdmOptionDashboardOption>,
    public val guardianOptions: List<GetConfigurationSetVdmOptionGuardianOption>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.GetConfigurationSetVdmOption): GetConfigurationSetVdmOption = GetConfigurationSetVdmOption(
            dashboardOptions = javaType.dashboardOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.GetConfigurationSetVdmOptionDashboardOption.Companion.toKotlin(args0)
                })
            }),
            guardianOptions = javaType.guardianOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.GetConfigurationSetVdmOptionGuardianOption.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
