@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDedicatedIpPool.
 * @property arn ARN of the Dedicated IP Pool.
 * @property dedicatedIps A list of objects describing the pool's dedicated IP's. See `dedicated_ips`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property poolName
 * @property scalingMode (Optional) IP pool scaling mode. Valid values: `STANDARD`, `MANAGED`.
 * @property tags A map of tags attached to the pool.
 */
public data class GetDedicatedIpPoolResult(
    public val arn: String,
    public val dedicatedIps: List<GetDedicatedIpPoolDedicatedIp>,
    public val id: String,
    public val poolName: String,
    public val scalingMode: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.GetDedicatedIpPoolResult): GetDedicatedIpPoolResult = GetDedicatedIpPoolResult(
            arn = javaType.arn(),
            dedicatedIps = javaType.dedicatedIps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sesv2.kotlin.outputs.GetDedicatedIpPoolDedicatedIp.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            poolName = javaType.poolName(),
            scalingMode = javaType.scalingMode(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
