@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property currentSigningKeyLength [Easy DKIM] The key length of the DKIM key pair in use.
 * @property domainSigningPrivateKey
 * @property domainSigningSelector
 * @property lastKeyGenerationTimestamp [Easy DKIM] The last time a key pair was generated for this identity.
 * @property nextSigningKeyLength [Easy DKIM] The key length of the future DKIM key pair to be generated. This can be changed at most once per day.
 * @property signingAttributesOrigin A string that indicates how DKIM was configured for the identity. `AWS_SES` indicates that DKIM was configured for the identity by using Easy DKIM. `EXTERNAL` indicates that DKIM was configured for the identity by using Bring Your Own DKIM (BYODKIM).
 * @property status Describes whether or not Amazon SES has successfully located the DKIM records in the DNS records for the domain. See the [AWS SES API v2 Reference](https://docs.aws.amazon.com/ses/latest/APIReference-V2/API_DkimAttributes.html#SES-Type-DkimAttributes-Status) for supported statuses.
 * @property tokens If you used Easy DKIM to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete. If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.
 */
public data class GetEmailIdentityDkimSigningAttribute(
    public val currentSigningKeyLength: String,
    public val domainSigningPrivateKey: String,
    public val domainSigningSelector: String,
    public val lastKeyGenerationTimestamp: String,
    public val nextSigningKeyLength: String,
    public val signingAttributesOrigin: String,
    public val status: String,
    public val tokens: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.GetEmailIdentityDkimSigningAttribute): GetEmailIdentityDkimSigningAttribute = GetEmailIdentityDkimSigningAttribute(
            currentSigningKeyLength = javaType.currentSigningKeyLength(),
            domainSigningPrivateKey = javaType.domainSigningPrivateKey(),
            domainSigningSelector = javaType.domainSigningSelector(),
            lastKeyGenerationTimestamp = javaType.lastKeyGenerationTimestamp(),
            nextSigningKeyLength = javaType.nextSigningKeyLength(),
            signingAttributesOrigin = javaType.signingAttributesOrigin(),
            status = javaType.status(),
            tokens = javaType.tokens().map({ args0 -> args0 }),
        )
    }
}
