@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sesv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getEmailIdentityMailFromAttributes.
 * @property behaviorOnMxFailure The action to take if the required MX record isn't found when you send an email. Valid values: `USE_DEFAULT_VALUE`, `REJECT_MESSAGE`.
 * @property emailIdentity
 * @property id The provider-assigned unique ID for this managed resource.
 * @property mailFromDomain The custom MAIL FROM domain that you want the verified identity to use.
 */
public data class GetEmailIdentityMailFromAttributesResult(
    public val behaviorOnMxFailure: String,
    public val emailIdentity: String,
    public val id: String,
    public val mailFromDomain: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sesv2.outputs.GetEmailIdentityMailFromAttributesResult): GetEmailIdentityMailFromAttributesResult = GetEmailIdentityMailFromAttributesResult(
            behaviorOnMxFailure = javaType.behaviorOnMxFailure(),
            emailIdentity = javaType.emailIdentity(),
            id = javaType.id(),
            mailFromDomain = javaType.mailFromDomain(),
        )
    }
}
