@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin

import com.pulumi.aws.sfn.ActivityArgs.builder
import com.pulumi.aws.sfn.kotlin.inputs.ActivityEncryptionConfigurationArgs
import com.pulumi.aws.sfn.kotlin.inputs.ActivityEncryptionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Step Function Activity resource
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sfnActivity = new aws.sfn.Activity("sfn_activity", {name: "my-activity"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sfn_activity = aws.sfn.Activity("sfn_activity", name="my-activity")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sfnActivity = new Aws.Sfn.Activity("sfn_activity", new()
 *     {
 *         Name = "my-activity",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sfn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sfn.NewActivity(ctx, "sfn_activity", &sfn.ActivityArgs{
 * 			Name: pulumi.String("my-activity"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.Activity;
 * import com.pulumi.aws.sfn.ActivityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnActivity = new Activity("sfnActivity", ActivityArgs.builder()
 *             .name("my-activity")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sfnActivity:
 *     type: aws:sfn:Activity
 *     name: sfn_activity
 *     properties:
 *       name: my-activity
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Encryption
 * > *NOTE:* See the section [Data at rest encyption](https://docs&#46;aws&#46;amazon&#46;com/step-functions/latest/dg/encryption-at-rest&#46;html) in the [AWS Step Functions Developer Guide](https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html) for more information about enabling encryption of data using a customer-managed key for Step Functions State Machines data.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sfnActivity = new aws.sfn.Activity("sfn_activity", {
 *     name: "my-activity",
 *     encryptionConfiguration: {
 *         kmsKeyId: kmsKeyForSfn.arn,
 *         type: "CUSTOMER_MANAGED_KMS_KEY",
 *         kmsDataKeyReusePeriodSeconds: 900,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sfn_activity = aws.sfn.Activity("sfn_activity",
 *     name="my-activity",
 *     encryption_configuration={
 *         "kms_key_id": kms_key_for_sfn["arn"],
 *         "type": "CUSTOMER_MANAGED_KMS_KEY",
 *         "kms_data_key_reuse_period_seconds": 900,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sfnActivity = new Aws.Sfn.Activity("sfn_activity", new()
 *     {
 *         Name = "my-activity",
 *         EncryptionConfiguration = new Aws.Sfn.Inputs.ActivityEncryptionConfigurationArgs
 *         {
 *             KmsKeyId = kmsKeyForSfn.Arn,
 *             Type = "CUSTOMER_MANAGED_KMS_KEY",
 *             KmsDataKeyReusePeriodSeconds = 900,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sfn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sfn.NewActivity(ctx, "sfn_activity", &sfn.ActivityArgs{
 * 			Name: pulumi.String("my-activity"),
 * 			EncryptionConfiguration: &sfn.ActivityEncryptionConfigurationArgs{
 * 				KmsKeyId:                     pulumi.Any(kmsKeyForSfn.Arn),
 * 				Type:                         pulumi.String("CUSTOMER_MANAGED_KMS_KEY"),
 * 				KmsDataKeyReusePeriodSeconds: pulumi.Int(900),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.Activity;
 * import com.pulumi.aws.sfn.ActivityArgs;
 * import com.pulumi.aws.sfn.inputs.ActivityEncryptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnActivity = new Activity("sfnActivity", ActivityArgs.builder()
 *             .name("my-activity")
 *             .encryptionConfiguration(ActivityEncryptionConfigurationArgs.builder()
 *                 .kmsKeyId(kmsKeyForSfn.arn())
 *                 .type("CUSTOMER_MANAGED_KMS_KEY")
 *                 .kmsDataKeyReusePeriodSeconds(900)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sfnActivity:
 *     type: aws:sfn:Activity
 *     name: sfn_activity
 *     properties:
 *       name: my-activity
 *       encryptionConfiguration:
 *         kmsKeyId: ${kmsKeyForSfn.arn}
 *         type: CUSTOMER_MANAGED_KMS_KEY
 *         kmsDataKeyReusePeriodSeconds: 900
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import activities using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:sfn/activity:Activity foo arn:aws:states:eu-west-1:123456789098:activity:bar
 * ```
 * @property encryptionConfiguration Defines what encryption configuration is used to encrypt data in the Activity. For more information see the section [Data at rest encyption](https://docs.aws.amazon.com/step-functions/latest/dg/encryption-at-rest.html) in the AWS Step Functions User Guide.
 * @property name The name of the activity to create.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ActivityArgs(
    public val encryptionConfiguration: Output<ActivityEncryptionConfigurationArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sfn.ActivityArgs> {
    override fun toJava(): com.pulumi.aws.sfn.ActivityArgs = com.pulumi.aws.sfn.ActivityArgs.builder()
        .encryptionConfiguration(
            encryptionConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [ActivityArgs].
 */
@PulumiTagMarker
public class ActivityArgsBuilder internal constructor() {
    private var encryptionConfiguration: Output<ActivityEncryptionConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Defines what encryption configuration is used to encrypt data in the Activity. For more information see the section [Data at rest encyption](https://docs.aws.amazon.com/step-functions/latest/dg/encryption-at-rest.html) in the AWS Step Functions User Guide.
     */
    @JvmName("sowtpelutbtfvids")
    public suspend fun encryptionConfiguration(`value`: Output<ActivityEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value The name of the activity to create.
     */
    @JvmName("dbmtdiwshpgjdqiw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ymueyuocyyiiokxm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Defines what encryption configuration is used to encrypt data in the Activity. For more information see the section [Data at rest encyption](https://docs.aws.amazon.com/step-functions/latest/dg/encryption-at-rest.html) in the AWS Step Functions User Guide.
     */
    @JvmName("augresfsfokmqcid")
    public suspend fun encryptionConfiguration(`value`: ActivityEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument Defines what encryption configuration is used to encrypt data in the Activity. For more information see the section [Data at rest encyption](https://docs.aws.amazon.com/step-functions/latest/dg/encryption-at-rest.html) in the AWS Step Functions User Guide.
     */
    @JvmName("dypdimfevxpiyrhx")
    public suspend fun encryptionConfiguration(argument: suspend ActivityEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityEncryptionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value The name of the activity to create.
     */
    @JvmName("kljmrmcofkpjsshj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ipfshovjcdrskhor")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bqbyecstxbujbcmf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ActivityArgs = ActivityArgs(
        encryptionConfiguration = encryptionConfiguration,
        name = name,
        tags = tags,
    )
}
