@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin

import com.pulumi.aws.sfn.AliasArgs.builder
import com.pulumi.aws.sfn.kotlin.inputs.AliasRoutingConfigurationArgs
import com.pulumi.aws.sfn.kotlin.inputs.AliasRoutingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Step Function State Machine Alias.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sfnAlias = new aws.sfn.Alias("sfn_alias", {
 *     name: "my_sfn_alias",
 *     routingConfigurations: [{
 *         stateMachineVersionArn: sfnTest.stateMachineVersionArn,
 *         weight: 100,
 *     }],
 * });
 * const mySfnAlias = new aws.sfn.Alias("my_sfn_alias", {
 *     name: "my_sfn_alias",
 *     routingConfigurations: [
 *         {
 *             stateMachineVersionArn: "arn:aws:states:us-east-1:12345:stateMachine:demo:3",
 *             weight: 50,
 *         },
 *         {
 *             stateMachineVersionArn: "arn:aws:states:us-east-1:12345:stateMachine:demo:2",
 *             weight: 50,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sfn_alias = aws.sfn.Alias("sfn_alias",
 *     name="my_sfn_alias",
 *     routing_configurations=[{
 *         "state_machine_version_arn": sfn_test["stateMachineVersionArn"],
 *         "weight": 100,
 *     }])
 * my_sfn_alias = aws.sfn.Alias("my_sfn_alias",
 *     name="my_sfn_alias",
 *     routing_configurations=[
 *         {
 *             "state_machine_version_arn": "arn:aws:states:us-east-1:12345:stateMachine:demo:3",
 *             "weight": 50,
 *         },
 *         {
 *             "state_machine_version_arn": "arn:aws:states:us-east-1:12345:stateMachine:demo:2",
 *             "weight": 50,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sfnAlias = new Aws.Sfn.Alias("sfn_alias", new()
 *     {
 *         Name = "my_sfn_alias",
 *         RoutingConfigurations = new[]
 *         {
 *             new Aws.Sfn.Inputs.AliasRoutingConfigurationArgs
 *             {
 *                 StateMachineVersionArn = sfnTest.StateMachineVersionArn,
 *                 Weight = 100,
 *             },
 *         },
 *     });
 *     var mySfnAlias = new Aws.Sfn.Alias("my_sfn_alias", new()
 *     {
 *         Name = "my_sfn_alias",
 *         RoutingConfigurations = new[]
 *         {
 *             new Aws.Sfn.Inputs.AliasRoutingConfigurationArgs
 *             {
 *                 StateMachineVersionArn = "arn:aws:states:us-east-1:12345:stateMachine:demo:3",
 *                 Weight = 50,
 *             },
 *             new Aws.Sfn.Inputs.AliasRoutingConfigurationArgs
 *             {
 *                 StateMachineVersionArn = "arn:aws:states:us-east-1:12345:stateMachine:demo:2",
 *                 Weight = 50,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sfn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sfn.NewAlias(ctx, "sfn_alias", &sfn.AliasArgs{
 * 			Name: pulumi.String("my_sfn_alias"),
 * 			RoutingConfigurations: sfn.AliasRoutingConfigurationArray{
 * 				&sfn.AliasRoutingConfigurationArgs{
 * 					StateMachineVersionArn: pulumi.Any(sfnTest.StateMachineVersionArn),
 * 					Weight:                 pulumi.Int(100),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sfn.NewAlias(ctx, "my_sfn_alias", &sfn.AliasArgs{
 * 			Name: pulumi.String("my_sfn_alias"),
 * 			RoutingConfigurations: sfn.AliasRoutingConfigurationArray{
 * 				&sfn.AliasRoutingConfigurationArgs{
 * 					StateMachineVersionArn: pulumi.String("arn:aws:states:us-east-1:12345:stateMachine:demo:3"),
 * 					Weight:                 pulumi.Int(50),
 * 				},
 * 				&sfn.AliasRoutingConfigurationArgs{
 * 					StateMachineVersionArn: pulumi.String("arn:aws:states:us-east-1:12345:stateMachine:demo:2"),
 * 					Weight:                 pulumi.Int(50),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.Alias;
 * import com.pulumi.aws.sfn.AliasArgs;
 * import com.pulumi.aws.sfn.inputs.AliasRoutingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sfnAlias = new Alias("sfnAlias", AliasArgs.builder()
 *             .name("my_sfn_alias")
 *             .routingConfigurations(AliasRoutingConfigurationArgs.builder()
 *                 .stateMachineVersionArn(sfnTest.stateMachineVersionArn())
 *                 .weight(100)
 *                 .build())
 *             .build());
 *         var mySfnAlias = new Alias("mySfnAlias", AliasArgs.builder()
 *             .name("my_sfn_alias")
 *             .routingConfigurations(
 *                 AliasRoutingConfigurationArgs.builder()
 *                     .stateMachineVersionArn("arn:aws:states:us-east-1:12345:stateMachine:demo:3")
 *                     .weight(50)
 *                     .build(),
 *                 AliasRoutingConfigurationArgs.builder()
 *                     .stateMachineVersionArn("arn:aws:states:us-east-1:12345:stateMachine:demo:2")
 *                     .weight(50)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sfnAlias:
 *     type: aws:sfn:Alias
 *     name: sfn_alias
 *     properties:
 *       name: my_sfn_alias
 *       routingConfigurations:
 *         - stateMachineVersionArn: ${sfnTest.stateMachineVersionArn}
 *           weight: 100
 *   mySfnAlias:
 *     type: aws:sfn:Alias
 *     name: my_sfn_alias
 *     properties:
 *       name: my_sfn_alias
 *       routingConfigurations:
 *         - stateMachineVersionArn: arn:aws:states:us-east-1:12345:stateMachine:demo:3
 *           weight: 50
 *         - stateMachineVersionArn: arn:aws:states:us-east-1:12345:stateMachine:demo:2
 *           weight: 50
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SFN (Step Functions) Alias using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:sfn/alias:Alias foo arn:aws:states:us-east-1:123456789098:stateMachine:myStateMachine:foo
 * ```
 * @property description Description of the alias.
 * @property name Name for the alias you are creating.
 * @property routingConfigurations The StateMachine alias' route configuration settings. Fields documented below
 */
public data class AliasArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val routingConfigurations: Output<List<AliasRoutingConfigurationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sfn.AliasArgs> {
    override fun toJava(): com.pulumi.aws.sfn.AliasArgs = com.pulumi.aws.sfn.AliasArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .routingConfigurations(
            routingConfigurations?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        ).build()
}

/**
 * Builder for [AliasArgs].
 */
@PulumiTagMarker
public class AliasArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var routingConfigurations: Output<List<AliasRoutingConfigurationArgs>>? = null

    /**
     * @param value Description of the alias.
     */
    @JvmName("fckveokqaikxnxps")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name for the alias you are creating.
     */
    @JvmName("mifouhmnsvijoghn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("vtbornxbpxtkuhhn")
    public suspend fun routingConfigurations(`value`: Output<List<AliasRoutingConfigurationArgs>>) {
        this.routingConfigurations = value
    }

    @JvmName("oxbpdhdgkddketvf")
    public suspend fun routingConfigurations(vararg values: Output<AliasRoutingConfigurationArgs>) {
        this.routingConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("qoeeyojqeqljdnap")
    public suspend fun routingConfigurations(values: List<Output<AliasRoutingConfigurationArgs>>) {
        this.routingConfigurations = Output.all(values)
    }

    /**
     * @param value Description of the alias.
     */
    @JvmName("hfirihsjgvmclsex")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name for the alias you are creating.
     */
    @JvmName("pfrkmcxhrtytxkrh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("cuhmiqbtitrueebh")
    public suspend fun routingConfigurations(`value`: List<AliasRoutingConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfigurations = mapped
    }

    /**
     * @param argument The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("xnvppkgyjkswqkcn")
    public suspend fun routingConfigurations(argument: List<suspend AliasRoutingConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AliasRoutingConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routingConfigurations = mapped
    }

    /**
     * @param argument The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("yrymxipobdvcsqwx")
    public suspend fun routingConfigurations(vararg argument: suspend AliasRoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AliasRoutingConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routingConfigurations = mapped
    }

    /**
     * @param argument The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("klvdolorhqwrdflh")
    public suspend fun routingConfigurations(argument: suspend AliasRoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AliasRoutingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.routingConfigurations = mapped
    }

    /**
     * @param values The StateMachine alias' route configuration settings. Fields documented below
     */
    @JvmName("pgxhjuigrmsenpnv")
    public suspend fun routingConfigurations(vararg values: AliasRoutingConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingConfigurations = mapped
    }

    internal fun build(): AliasArgs = AliasArgs(
        description = description,
        name = name,
        routingConfigurations = routingConfigurations,
    )
}
