@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin

import com.pulumi.aws.sfn.StateMachineArgs.builder
import com.pulumi.aws.sfn.kotlin.inputs.StateMachineEncryptionConfigurationArgs
import com.pulumi.aws.sfn.kotlin.inputs.StateMachineEncryptionConfigurationArgsBuilder
import com.pulumi.aws.sfn.kotlin.inputs.StateMachineLoggingConfigurationArgs
import com.pulumi.aws.sfn.kotlin.inputs.StateMachineLoggingConfigurationArgsBuilder
import com.pulumi.aws.sfn.kotlin.inputs.StateMachineTracingConfigurationArgs
import com.pulumi.aws.sfn.kotlin.inputs.StateMachineTracingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Step Function State Machine resource
 * ## Example Usage
 * ### Basic (Standard Workflow)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // ...
 * const sfnStateMachine = new aws.sfn.StateMachine("sfn_state_machine", {
 *     name: "my-state-machine",
 *     roleArn: iamForSfn.arn,
 *     definition: `{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "${lambda.arn}",
 *       "End": true
 *     }
 *   }
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # ...
 * sfn_state_machine = aws.sfn.StateMachine("sfn_state_machine",
 *     name="my-state-machine",
 *     role_arn=iam_for_sfn["arn"],
 *     definition=f"""{{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {{
 *     "HelloWorld": {{
 *       "Type": "Task",
 *       "Resource": "{lambda_["arn"]}",
 *       "End": true
 *     }}
 *   }}
 * }}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // ...
 *     var sfnStateMachine = new Aws.Sfn.StateMachine("sfn_state_machine", new()
 *     {
 *         Name = "my-state-machine",
 *         RoleArn = iamForSfn.Arn,
 *         Definition = @$"{{
 *   ""Comment"": ""A Hello World example of the Amazon States Language using an AWS Lambda Function"",
 *   ""StartAt"": ""HelloWorld"",
 *   ""States"": {{
 *     ""HelloWorld"": {{
 *       ""Type"": ""Task"",
 *       ""Resource"": ""{lambda.Arn}"",
 *       ""End"": true
 *     }}
 *   }}
 * }}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sfn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// ...
 * 		_, err := sfn.NewStateMachine(ctx, "sfn_state_machine", &sfn.StateMachineArgs{
 * 			Name:    pulumi.String("my-state-machine"),
 * 			RoleArn: pulumi.Any(iamForSfn.Arn),
 * 			Definition: pulumi.Sprintf(`{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%v",
 *       "End": true
 *     }
 *   }
 * }
 * `, lambda.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // ...
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .name("my-state-machine")
 *             .roleArn(iamForSfn.arn())
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", lambda.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # ...
 *   sfnStateMachine:
 *     type: aws:sfn:StateMachine
 *     name: sfn_state_machine
 *     properties:
 *       name: my-state-machine
 *       roleArn: ${iamForSfn.arn}
 *       definition: |
 *         {
 *           "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *           "StartAt": "HelloWorld",
 *           "States": {
 *             "HelloWorld": {
 *               "Type": "Task",
 *               "Resource": "${lambda.arn}",
 *               "End": true
 *             }
 *           }
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic (Express Workflow)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // ...
 * const sfnStateMachine = new aws.sfn.StateMachine("sfn_state_machine", {
 *     name: "my-state-machine",
 *     roleArn: iamForSfn.arn,
 *     type: "EXPRESS",
 *     definition: `{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "${lambda.arn}",
 *       "End": true
 *     }
 *   }
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # ...
 * sfn_state_machine = aws.sfn.StateMachine("sfn_state_machine",
 *     name="my-state-machine",
 *     role_arn=iam_for_sfn["arn"],
 *     type="EXPRESS",
 *     definition=f"""{{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {{
 *     "HelloWorld": {{
 *       "Type": "Task",
 *       "Resource": "{lambda_["arn"]}",
 *       "End": true
 *     }}
 *   }}
 * }}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // ...
 *     var sfnStateMachine = new Aws.Sfn.StateMachine("sfn_state_machine", new()
 *     {
 *         Name = "my-state-machine",
 *         RoleArn = iamForSfn.Arn,
 *         Type = "EXPRESS",
 *         Definition = @$"{{
 *   ""Comment"": ""A Hello World example of the Amazon States Language using an AWS Lambda Function"",
 *   ""StartAt"": ""HelloWorld"",
 *   ""States"": {{
 *     ""HelloWorld"": {{
 *       ""Type"": ""Task"",
 *       ""Resource"": ""{lambda.Arn}"",
 *       ""End"": true
 *     }}
 *   }}
 * }}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sfn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// ...
 * 		_, err := sfn.NewStateMachine(ctx, "sfn_state_machine", &sfn.StateMachineArgs{
 * 			Name:    pulumi.String("my-state-machine"),
 * 			RoleArn: pulumi.Any(iamForSfn.Arn),
 * 			Type:    pulumi.String("EXPRESS"),
 * 			Definition: pulumi.Sprintf(`{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%v",
 *       "End": true
 *     }
 *   }
 * }
 * `, lambda.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // ...
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .name("my-state-machine")
 *             .roleArn(iamForSfn.arn())
 *             .type("EXPRESS")
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", lambda.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # ...
 *   sfnStateMachine:
 *     type: aws:sfn:StateMachine
 *     name: sfn_state_machine
 *     properties:
 *       name: my-state-machine
 *       roleArn: ${iamForSfn.arn}
 *       type: EXPRESS
 *       definition: |
 *         {
 *           "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *           "StartAt": "HelloWorld",
 *           "States": {
 *             "HelloWorld": {
 *               "Type": "Task",
 *               "Resource": "${lambda.arn}",
 *               "End": true
 *             }
 *           }
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Publish (Publish SFN version)
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // ...
 * const sfnStateMachine = new aws.sfn.StateMachine("sfn_state_machine", {
 *     name: "my-state-machine",
 *     roleArn: iamForSfn.arn,
 *     publish: true,
 *     type: "EXPRESS",
 *     definition: `{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "${lambda.arn}",
 *       "End": true
 *     }
 *   }
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # ...
 * sfn_state_machine = aws.sfn.StateMachine("sfn_state_machine",
 *     name="my-state-machine",
 *     role_arn=iam_for_sfn["arn"],
 *     publish=True,
 *     type="EXPRESS",
 *     definition=f"""{{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {{
 *     "HelloWorld": {{
 *       "Type": "Task",
 *       "Resource": "{lambda_["arn"]}",
 *       "End": true
 *     }}
 *   }}
 * }}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // ...
 *     var sfnStateMachine = new Aws.Sfn.StateMachine("sfn_state_machine", new()
 *     {
 *         Name = "my-state-machine",
 *         RoleArn = iamForSfn.Arn,
 *         Publish = true,
 *         Type = "EXPRESS",
 *         Definition = @$"{{
 *   ""Comment"": ""A Hello World example of the Amazon States Language using an AWS Lambda Function"",
 *   ""StartAt"": ""HelloWorld"",
 *   ""States"": {{
 *     ""HelloWorld"": {{
 *       ""Type"": ""Task"",
 *       ""Resource"": ""{lambda.Arn}"",
 *       ""End"": true
 *     }}
 *   }}
 * }}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sfn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// ...
 * 		_, err := sfn.NewStateMachine(ctx, "sfn_state_machine", &sfn.StateMachineArgs{
 * 			Name:    pulumi.String("my-state-machine"),
 * 			RoleArn: pulumi.Any(iamForSfn.Arn),
 * 			Publish: pulumi.Bool(true),
 * 			Type:    pulumi.String("EXPRESS"),
 * 			Definition: pulumi.Sprintf(`{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%v",
 *       "End": true
 *     }
 *   }
 * }
 * `, lambda.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // ...
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .name("my-state-machine")
 *             .roleArn(iamForSfn.arn())
 *             .publish(true)
 *             .type("EXPRESS")
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", lambda.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # ...
 *   sfnStateMachine:
 *     type: aws:sfn:StateMachine
 *     name: sfn_state_machine
 *     properties:
 *       name: my-state-machine
 *       roleArn: ${iamForSfn.arn}
 *       publish: true
 *       type: EXPRESS
 *       definition: |
 *         {
 *           "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *           "StartAt": "HelloWorld",
 *           "States": {
 *             "HelloWorld": {
 *               "Type": "Task",
 *               "Resource": "${lambda.arn}",
 *               "End": true
 *             }
 *           }
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Logging
 * > *NOTE:* See the [AWS Step Functions Developer Guide](https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html) for more information about enabling Step Function logging.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // ...
 * const sfnStateMachine = new aws.sfn.StateMachine("sfn_state_machine", {
 *     name: "my-state-machine",
 *     roleArn: iamForSfn.arn,
 *     definition: `{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "${lambda.arn}",
 *       "End": true
 *     }
 *   }
 * }
 * `,
 *     loggingConfiguration: {
 *         logDestination: `${logGroupForSfn.arn}:*`,
 *         includeExecutionData: true,
 *         level: "ERROR",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # ...
 * sfn_state_machine = aws.sfn.StateMachine("sfn_state_machine",
 *     name="my-state-machine",
 *     role_arn=iam_for_sfn["arn"],
 *     definition=f"""{{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {{
 *     "HelloWorld": {{
 *       "Type": "Task",
 *       "Resource": "{lambda_["arn"]}",
 *       "End": true
 *     }}
 *   }}
 * }}
 * """,
 *     logging_configuration={
 *         "log_destination": f"{log_group_for_sfn['arn']}:*",
 *         "include_execution_data": True,
 *         "level": "ERROR",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // ...
 *     var sfnStateMachine = new Aws.Sfn.StateMachine("sfn_state_machine", new()
 *     {
 *         Name = "my-state-machine",
 *         RoleArn = iamForSfn.Arn,
 *         Definition = @$"{{
 *   ""Comment"": ""A Hello World example of the Amazon States Language using an AWS Lambda Function"",
 *   ""StartAt"": ""HelloWorld"",
 *   ""States"": {{
 *     ""HelloWorld"": {{
 *       ""Type"": ""Task"",
 *       ""Resource"": ""{lambda.Arn}"",
 *       ""End"": true
 *     }}
 *   }}
 * }}
 * ",
 *         LoggingConfiguration = new Aws.Sfn.Inputs.StateMachineLoggingConfigurationArgs
 *         {
 *             LogDestination = $"{logGroupForSfn.Arn}:*",
 *             IncludeExecutionData = true,
 *             Level = "ERROR",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sfn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// ...
 * 		_, err := sfn.NewStateMachine(ctx, "sfn_state_machine", &sfn.StateMachineArgs{
 * 			Name:    pulumi.String("my-state-machine"),
 * 			RoleArn: pulumi.Any(iamForSfn.Arn),
 * 			Definition: pulumi.Sprintf(`{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%v",
 *       "End": true
 *     }
 *   }
 * }
 * `, lambda.Arn),
 * 			LoggingConfiguration: &sfn.StateMachineLoggingConfigurationArgs{
 * 				LogDestination:       pulumi.Sprintf("%v:*", logGroupForSfn.Arn),
 * 				IncludeExecutionData: pulumi.Bool(true),
 * 				Level:                pulumi.String("ERROR"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import com.pulumi.aws.sfn.inputs.StateMachineLoggingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // ...
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .name("my-state-machine")
 *             .roleArn(iamForSfn.arn())
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", lambda.arn()))
 *             .loggingConfiguration(StateMachineLoggingConfigurationArgs.builder()
 *                 .logDestination(String.format("%s:*", logGroupForSfn.arn()))
 *                 .includeExecutionData(true)
 *                 .level("ERROR")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # ...
 *   sfnStateMachine:
 *     type: aws:sfn:StateMachine
 *     name: sfn_state_machine
 *     properties:
 *       name: my-state-machine
 *       roleArn: ${iamForSfn.arn}
 *       definition: |
 *         {
 *           "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *           "StartAt": "HelloWorld",
 *           "States": {
 *             "HelloWorld": {
 *               "Type": "Task",
 *               "Resource": "${lambda.arn}",
 *               "End": true
 *             }
 *           }
 *         }
 *       loggingConfiguration:
 *         logDestination: ${logGroupForSfn.arn}:*
 *         includeExecutionData: true
 *         level: ERROR
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Encryption
 * > *NOTE:* See the section [Data at rest encyption](https://docs&#46;aws&#46;amazon&#46;com/step-functions/latest/dg/encryption-at-rest&#46;html) in the [AWS Step Functions Developer Guide](https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html) for more information about enabling encryption of data using a customer-managed key for Step Functions State Machines data.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // ...
 * const sfnStateMachine = new aws.sfn.StateMachine("sfn_state_machine", {
 *     name: "my-state-machine",
 *     roleArn: iamForSfn.arn,
 *     definition: `{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "${lambda.arn}",
 *       "End": true
 *     }
 *   }
 * }
 * `,
 *     encryptionConfiguration: {
 *         kmsKeyId: kmsKeyForSfn.arn,
 *         type: "CUSTOMER_MANAGED_KMS_KEY",
 *         kmsDataKeyReusePeriodSeconds: 900,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # ...
 * sfn_state_machine = aws.sfn.StateMachine("sfn_state_machine",
 *     name="my-state-machine",
 *     role_arn=iam_for_sfn["arn"],
 *     definition=f"""{{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {{
 *     "HelloWorld": {{
 *       "Type": "Task",
 *       "Resource": "{lambda_["arn"]}",
 *       "End": true
 *     }}
 *   }}
 * }}
 * """,
 *     encryption_configuration={
 *         "kms_key_id": kms_key_for_sfn["arn"],
 *         "type": "CUSTOMER_MANAGED_KMS_KEY",
 *         "kms_data_key_reuse_period_seconds": 900,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // ...
 *     var sfnStateMachine = new Aws.Sfn.StateMachine("sfn_state_machine", new()
 *     {
 *         Name = "my-state-machine",
 *         RoleArn = iamForSfn.Arn,
 *         Definition = @$"{{
 *   ""Comment"": ""A Hello World example of the Amazon States Language using an AWS Lambda Function"",
 *   ""StartAt"": ""HelloWorld"",
 *   ""States"": {{
 *     ""HelloWorld"": {{
 *       ""Type"": ""Task"",
 *       ""Resource"": ""{lambda.Arn}"",
 *       ""End"": true
 *     }}
 *   }}
 * }}
 * ",
 *         EncryptionConfiguration = new Aws.Sfn.Inputs.StateMachineEncryptionConfigurationArgs
 *         {
 *             KmsKeyId = kmsKeyForSfn.Arn,
 *             Type = "CUSTOMER_MANAGED_KMS_KEY",
 *             KmsDataKeyReusePeriodSeconds = 900,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sfn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// ...
 * 		_, err := sfn.NewStateMachine(ctx, "sfn_state_machine", &sfn.StateMachineArgs{
 * 			Name:    pulumi.String("my-state-machine"),
 * 			RoleArn: pulumi.Any(iamForSfn.Arn),
 * 			Definition: pulumi.Sprintf(`{
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%v",
 *       "End": true
 *     }
 *   }
 * }
 * `, lambda.Arn),
 * 			EncryptionConfiguration: &sfn.StateMachineEncryptionConfigurationArgs{
 * 				KmsKeyId:                     pulumi.Any(kmsKeyForSfn.Arn),
 * 				Type:                         pulumi.String("CUSTOMER_MANAGED_KMS_KEY"),
 * 				KmsDataKeyReusePeriodSeconds: pulumi.Int(900),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sfn.StateMachine;
 * import com.pulumi.aws.sfn.StateMachineArgs;
 * import com.pulumi.aws.sfn.inputs.StateMachineEncryptionConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // ...
 *         var sfnStateMachine = new StateMachine("sfnStateMachine", StateMachineArgs.builder()
 *             .name("my-state-machine")
 *             .roleArn(iamForSfn.arn())
 *             .definition("""
 * {
 *   "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *   "StartAt": "HelloWorld",
 *   "States": {
 *     "HelloWorld": {
 *       "Type": "Task",
 *       "Resource": "%s",
 *       "End": true
 *     }
 *   }
 * }
 * ", lambda.arn()))
 *             .encryptionConfiguration(StateMachineEncryptionConfigurationArgs.builder()
 *                 .kmsKeyId(kmsKeyForSfn.arn())
 *                 .type("CUSTOMER_MANAGED_KMS_KEY")
 *                 .kmsDataKeyReusePeriodSeconds(900)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # ...
 *   sfnStateMachine:
 *     type: aws:sfn:StateMachine
 *     name: sfn_state_machine
 *     properties:
 *       name: my-state-machine
 *       roleArn: ${iamForSfn.arn}
 *       definition: |
 *         {
 *           "Comment": "A Hello World example of the Amazon States Language using an AWS Lambda Function",
 *           "StartAt": "HelloWorld",
 *           "States": {
 *             "HelloWorld": {
 *               "Type": "Task",
 *               "Resource": "${lambda.arn}",
 *               "End": true
 *             }
 *           }
 *         }
 *       encryptionConfiguration:
 *         kmsKeyId: ${kmsKeyForSfn.arn}
 *         type: CUSTOMER_MANAGED_KMS_KEY
 *         kmsDataKeyReusePeriodSeconds: 900
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import State Machines using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:sfn/stateMachine:StateMachine foo arn:aws:states:eu-west-1:123456789098:stateMachine:bar
 * ```
 * @property definition The [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) definition of the state machine.
 * @property encryptionConfiguration Defines what encryption configuration is used to encrypt data in the State Machine. For more information see [TBD] in the AWS Step Functions User Guide.
 * @property loggingConfiguration Defines what execution history events are logged and where they are logged. The `logging_configuration` parameter is only valid when `type` is set to `EXPRESS`. Defaults to `OFF`. For more information see [Logging Express Workflows](https://docs&#46;aws&#46;amazon&#46;com/step-functions/latest/dg/cw-logs&#46;html) and [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
 * @property name The name of the state machine. The name should only contain `0`-`9`, `A`-`Z`, `a`-`z`, `-` and `_`. If omitted, the provider will assign a random, unique name.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property publish Set to true to publish a version of the state machine during creation. Default: false.
 * @property roleArn The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tracingConfiguration Selects whether AWS X-Ray tracing is enabled.
 * @property type Determines whether a Standard or Express state machine is created. The default is `STANDARD`. You cannot update the type of a state machine once it has been created. Valid values: `STANDARD`, `EXPRESS`.
 */
public data class StateMachineArgs(
    public val definition: Output<String>? = null,
    public val encryptionConfiguration: Output<StateMachineEncryptionConfigurationArgs>? = null,
    public val loggingConfiguration: Output<StateMachineLoggingConfigurationArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val publish: Output<Boolean>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tracingConfiguration: Output<StateMachineTracingConfigurationArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sfn.StateMachineArgs> {
    override fun toJava(): com.pulumi.aws.sfn.StateMachineArgs =
        com.pulumi.aws.sfn.StateMachineArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0 }))
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .loggingConfiguration(
                loggingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .publish(publish?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tracingConfiguration(
                tracingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StateMachineArgs].
 */
@PulumiTagMarker
public class StateMachineArgsBuilder internal constructor() {
    private var definition: Output<String>? = null

    private var encryptionConfiguration: Output<StateMachineEncryptionConfigurationArgs>? = null

    private var loggingConfiguration: Output<StateMachineLoggingConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var publish: Output<Boolean>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tracingConfiguration: Output<StateMachineTracingConfigurationArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) definition of the state machine.
     */
    @JvmName("ofjqyjvrgnrcshpa")
    public suspend fun definition(`value`: Output<String>) {
        this.definition = value
    }

    /**
     * @param value Defines what encryption configuration is used to encrypt data in the State Machine. For more information see [TBD] in the AWS Step Functions User Guide.
     */
    @JvmName("ynlgmwoxxgtxxkqf")
    public suspend fun encryptionConfiguration(`value`: Output<StateMachineEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value Defines what execution history events are logged and where they are logged. The `logging_configuration` parameter is only valid when `type` is set to `EXPRESS`. Defaults to `OFF`. For more information see [Logging Express Workflows](https://docs&#46;aws&#46;amazon&#46;com/step-functions/latest/dg/cw-logs&#46;html) and [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
     */
    @JvmName("ysqmekftbsfyyqhx")
    public suspend fun loggingConfiguration(`value`: Output<StateMachineLoggingConfigurationArgs>) {
        this.loggingConfiguration = value
    }

    /**
     * @param value The name of the state machine. The name should only contain `0`-`9`, `A`-`Z`, `a`-`z`, `-` and `_`. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("bmhrkswvejtexues")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("dujsnlvrxbjnqorb")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Set to true to publish a version of the state machine during creation. Default: false.
     */
    @JvmName("tpgajbcvtavxnxjj")
    public suspend fun publish(`value`: Output<Boolean>) {
        this.publish = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
     */
    @JvmName("bkiqvdgryimkwamp")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("natjyyvuaxtgkhsu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Selects whether AWS X-Ray tracing is enabled.
     */
    @JvmName("ryqujfpwiuupnfde")
    public suspend fun tracingConfiguration(`value`: Output<StateMachineTracingConfigurationArgs>) {
        this.tracingConfiguration = value
    }

    /**
     * @param value Determines whether a Standard or Express state machine is created. The default is `STANDARD`. You cannot update the type of a state machine once it has been created. Valid values: `STANDARD`, `EXPRESS`.
     */
    @JvmName("mfretmtrnoryeprv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The [Amazon States Language](https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html) definition of the state machine.
     */
    @JvmName("nulrghrmucvsidtm")
    public suspend fun definition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param value Defines what encryption configuration is used to encrypt data in the State Machine. For more information see [TBD] in the AWS Step Functions User Guide.
     */
    @JvmName("tanvoutusyxjifdn")
    public suspend fun encryptionConfiguration(`value`: StateMachineEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument Defines what encryption configuration is used to encrypt data in the State Machine. For more information see [TBD] in the AWS Step Functions User Guide.
     */
    @JvmName("usnlvgegjfifwjen")
    public suspend fun encryptionConfiguration(argument: suspend StateMachineEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StateMachineEncryptionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value Defines what execution history events are logged and where they are logged. The `logging_configuration` parameter is only valid when `type` is set to `EXPRESS`. Defaults to `OFF`. For more information see [Logging Express Workflows](https://docs&#46;aws&#46;amazon&#46;com/step-functions/latest/dg/cw-logs&#46;html) and [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
     */
    @JvmName("iidgoisllkpdgjvi")
    public suspend fun loggingConfiguration(`value`: StateMachineLoggingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfiguration = mapped
    }

    /**
     * @param argument Defines what execution history events are logged and where they are logged. The `logging_configuration` parameter is only valid when `type` is set to `EXPRESS`. Defaults to `OFF`. For more information see [Logging Express Workflows](https://docs&#46;aws&#46;amazon&#46;com/step-functions/latest/dg/cw-logs&#46;html) and [Log Levels](https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html) in the AWS Step Functions User Guide.
     */
    @JvmName("dipypryydgfuycmb")
    public suspend fun loggingConfiguration(argument: suspend StateMachineLoggingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StateMachineLoggingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loggingConfiguration = mapped
    }

    /**
     * @param value The name of the state machine. The name should only contain `0`-`9`, `A`-`Z`, `a`-`z`, `-` and `_`. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("qadlyvllowxkuprw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("jyfooltxdxquewae")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Set to true to publish a version of the state machine during creation. Default: false.
     */
    @JvmName("kndnnaffkhgjrqrp")
    public suspend fun publish(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publish = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
     */
    @JvmName("qcixiefqkjoljjbx")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mewcbcscissdhymb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mrracomohcvdljiu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Selects whether AWS X-Ray tracing is enabled.
     */
    @JvmName("krlkbsrbpwjxiief")
    public suspend fun tracingConfiguration(`value`: StateMachineTracingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracingConfiguration = mapped
    }

    /**
     * @param argument Selects whether AWS X-Ray tracing is enabled.
     */
    @JvmName("ifnnapqhwvykkvrk")
    public suspend fun tracingConfiguration(argument: suspend StateMachineTracingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StateMachineTracingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tracingConfiguration = mapped
    }

    /**
     * @param value Determines whether a Standard or Express state machine is created. The default is `STANDARD`. You cannot update the type of a state machine once it has been created. Valid values: `STANDARD`, `EXPRESS`.
     */
    @JvmName("bmkmsiybbjtfrkjm")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): StateMachineArgs = StateMachineArgs(
        definition = definition,
        encryptionConfiguration = encryptionConfiguration,
        loggingConfiguration = loggingConfiguration,
        name = name,
        namePrefix = namePrefix,
        publish = publish,
        roleArn = roleArn,
        tags = tags,
        tracingConfiguration = tracingConfiguration,
        type = type,
    )
}
