@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.inputs

import com.pulumi.aws.sfn.inputs.ActivityEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsDataKeyReusePeriodSeconds Maximum duration for which Activities will reuse data keys. When the period expires, Activities will call GenerateDataKey. This setting only applies to customer managed KMS key and does not apply to AWS owned KMS key.
 * @property kmsKeyId The alias, alias ARN, key ID, or key ARN of the symmetric encryption KMS key that encrypts the data key. To specify a KMS key in a different AWS account, the customer must use the key ARN or alias ARN. For more information regarding kms_key_id, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the KMS documentation.
 * @property type The encryption option specified for the activity. Valid values: `AWS_KMS_KEY`, `CUSTOMER_MANAGED_KMS_KEY`
 */
public data class ActivityEncryptionConfigurationArgs(
    public val kmsDataKeyReusePeriodSeconds: Output<Int>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sfn.inputs.ActivityEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sfn.inputs.ActivityEncryptionConfigurationArgs =
        com.pulumi.aws.sfn.inputs.ActivityEncryptionConfigurationArgs.builder()
            .kmsDataKeyReusePeriodSeconds(kmsDataKeyReusePeriodSeconds?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActivityEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class ActivityEncryptionConfigurationArgsBuilder internal constructor() {
    private var kmsDataKeyReusePeriodSeconds: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Maximum duration for which Activities will reuse data keys. When the period expires, Activities will call GenerateDataKey. This setting only applies to customer managed KMS key and does not apply to AWS owned KMS key.
     */
    @JvmName("xlxnqngkttgruamb")
    public suspend fun kmsDataKeyReusePeriodSeconds(`value`: Output<Int>) {
        this.kmsDataKeyReusePeriodSeconds = value
    }

    /**
     * @param value The alias, alias ARN, key ID, or key ARN of the symmetric encryption KMS key that encrypts the data key. To specify a KMS key in a different AWS account, the customer must use the key ARN or alias ARN. For more information regarding kms_key_id, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the KMS documentation.
     */
    @JvmName("vbhpqvqsuocqtnxg")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The encryption option specified for the activity. Valid values: `AWS_KMS_KEY`, `CUSTOMER_MANAGED_KMS_KEY`
     */
    @JvmName("gktuuiwdkckdkhja")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Maximum duration for which Activities will reuse data keys. When the period expires, Activities will call GenerateDataKey. This setting only applies to customer managed KMS key and does not apply to AWS owned KMS key.
     */
    @JvmName("qtbwvvkpaldogpdq")
    public suspend fun kmsDataKeyReusePeriodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsDataKeyReusePeriodSeconds = mapped
    }

    /**
     * @param value The alias, alias ARN, key ID, or key ARN of the symmetric encryption KMS key that encrypts the data key. To specify a KMS key in a different AWS account, the customer must use the key ARN or alias ARN. For more information regarding kms_key_id, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the KMS documentation.
     */
    @JvmName("gaosfgokxjenaykn")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The encryption option specified for the activity. Valid values: `AWS_KMS_KEY`, `CUSTOMER_MANAGED_KMS_KEY`
     */
    @JvmName("skgpoacrlwjwqpih")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ActivityEncryptionConfigurationArgs = ActivityEncryptionConfigurationArgs(
        kmsDataKeyReusePeriodSeconds = kmsDataKeyReusePeriodSeconds,
        kmsKeyId = kmsKeyId,
        type = type,
    )
}
