@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.inputs

import com.pulumi.aws.sfn.inputs.GetActivityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getActivity.
 * @property arn ARN that identifies the activity.
 * @property name Name that identifies the activity.
 */
public data class GetActivityPlainArgs(
    public val arn: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.aws.sfn.inputs.GetActivityPlainArgs> {
    override fun toJava(): com.pulumi.aws.sfn.inputs.GetActivityPlainArgs =
        com.pulumi.aws.sfn.inputs.GetActivityPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetActivityPlainArgs].
 */
@PulumiTagMarker
public class GetActivityPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var name: String? = null

    /**
     * @param value ARN that identifies the activity.
     */
    @JvmName("kkkktasfmdavoxre")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Name that identifies the activity.
     */
    @JvmName("qlbyuvunaucteito")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetActivityPlainArgs = GetActivityPlainArgs(
        arn = arn,
        name = name,
    )
}
