@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sfn.kotlin.inputs

import com.pulumi.aws.sfn.inputs.GetStateMachineVersionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getStateMachineVersions.
 * @property statemachineArn ARN of the State Machine.
 */
public data class GetStateMachineVersionsPlainArgs(
    public val statemachineArn: String,
) : ConvertibleToJava<com.pulumi.aws.sfn.inputs.GetStateMachineVersionsPlainArgs> {
    override fun toJava(): com.pulumi.aws.sfn.inputs.GetStateMachineVersionsPlainArgs =
        com.pulumi.aws.sfn.inputs.GetStateMachineVersionsPlainArgs.builder()
            .statemachineArn(statemachineArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStateMachineVersionsPlainArgs].
 */
@PulumiTagMarker
public class GetStateMachineVersionsPlainArgsBuilder internal constructor() {
    private var statemachineArn: String? = null

    /**
     * @param value ARN of the State Machine.
     */
    @JvmName("hbgvbbhffrbwwsnh")
    public suspend fun statemachineArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.statemachineArn = mapped
    }

    internal fun build(): GetStateMachineVersionsPlainArgs = GetStateMachineVersionsPlainArgs(
        statemachineArn = statemachineArn ?: throw PulumiNullFieldException("statemachineArn"),
    )
}
